import { TypeAlias } from './TypeAlias';
import { TypeBuilder } from '../type/TypeBuilder';
import type { CustomValidator } from './types';
import type { Type, TypeMap } from '../type';
import type { Printable } from '../../util/print/types';
export declare class TypeSystem implements Printable {
    readonly t: TypeBuilder;
    protected readonly aliases: Map<string, TypeAlias<string, any>>;
    readonly alias: <K extends string, T extends Type>(id: K, type: T) => TypeAlias<K, T>;
    importTypes<A extends TypeMap>(types: A): {
        readonly [K in keyof A]: TypeAlias<K extends string ? K : never, A[K]>;
    };
    readonly unalias: <K extends string>(id: K) => TypeAlias<K, Type>;
    readonly hasAlias: (id: string) => boolean;
    readonly resolve: <K extends string>(id: K) => TypeAlias<K, Type>;
    protected readonly customValidators: Map<string, CustomValidator>;
    readonly addCustomValidator: (validator: CustomValidator) => void;
    readonly getCustomValidator: (name: string) => CustomValidator;
    exportTypes(): Record<string, unknown>;
    toString(tab?: string): string;
}
