"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeRouter = void 0;
const TypeSystem_1 = require("./TypeSystem");
class TypeRouter {
    constructor(options) {
        this.system = options.system;
        this.t = this.system.t;
        this.routes = options.routes;
        this.system.importTypes(this.routes);
    }
    merge(router) {
        return new TypeRouter({
            system: this.system,
            routes: {
                ...this.routes,
                ...router.routes,
            },
        });
    }
    extend(routes) {
        const router = new TypeRouter({ system: this.system, routes: routes(this) });
        return this.merge(router);
    }
}
exports.TypeRouter = TypeRouter;
TypeRouter.create = (routes) => {
    const system = new TypeSystem_1.TypeSystem();
    const router = new TypeRouter({
        system,
        routes: {},
    });
    return routes ? router.extend(routes) : router;
};
