"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonTextEncoderCodegenContext = void 0;
const codegen_1 = require("../../../util/codegen");
const asString_1 = require("../../../util/strings/asString");
const base64_1 = require("../../../util/base64");
class WriteTextStep {
    constructor(str) {
        this.str = str;
    }
}
class JsonTextEncoderCodegenContext {
    constructor(options) {
        this.options = options;
        this.base64Linked = false;
        this.codegen = new codegen_1.Codegen({
            name: 'toJson' + (options.name ? '_' + options.name : ''),
            prologue: `var s = '';`,
            epilogue: `return s;`,
            processSteps: (steps) => {
                const stepsJoined = [];
                for (let i = 0; i < steps.length; i++) {
                    const step = steps[i];
                    if (step instanceof codegen_1.CodegenStepExecJs)
                        stepsJoined.push(step);
                    else if (step instanceof WriteTextStep) {
                        const last = stepsJoined[stepsJoined.length - 1];
                        if (last instanceof WriteTextStep)
                            last.str += step.str;
                        else
                            stepsJoined.push(step);
                    }
                }
                const execSteps = [];
                for (const step of stepsJoined) {
                    if (step instanceof codegen_1.CodegenStepExecJs) {
                        execSteps.push(step);
                    }
                    else if (step instanceof WriteTextStep) {
                        const js = `s += ${JSON.stringify(step.str)};`;
                        execSteps.push(new codegen_1.CodegenStepExecJs(js));
                    }
                }
                return execSteps;
            },
        });
        this.codegen.linkDependency(asString_1.asString, 'asString');
        this.codegen.linkDependency(JSON.stringify, 'stringify');
    }
    js(js) {
        this.codegen.js(js);
    }
    writeText(str) {
        this.codegen.step(new WriteTextStep(str));
    }
    linkBase64() {
        if (this.base64Linked)
            return;
        this.codegen.linkDependency(base64_1.toBase64, 'toBase64');
    }
    compile() {
        return this.codegen.compile();
    }
}
exports.JsonTextEncoderCodegenContext = JsonTextEncoderCodegenContext;
