"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamStdout = void 0;
const json_pointer_1 = require("../../json-pointer");
class CliParamStdout {
    constructor() {
        this.param = 'stdout';
        this.short = 'out';
        this.title = 'Write data to STDOUT';
        this.example = '--out=/foo';
        this.createInstance = (cli, _, rawValue) => {
            return new (class {
                constructor() {
                    this.onResponse = async () => {
                        const pointer = String(rawValue);
                        (0, json_pointer_1.validateJsonPointer)(pointer);
                        const path = (0, json_pointer_1.toPath)(pointer);
                        cli.response = (0, json_pointer_1.find)(cli.response, path).val;
                    };
                }
            })();
        };
    }
}
exports.CliParamStdout = CliParamStdout;
