"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamPlan = void 0;
const toTree_1 = require("../../json-text/toTree");
const util_1 = require("../util");
class CliParamPlan {
    constructor() {
        this.param = 'plan';
        this.title = 'Show execution plan';
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onBeforeCall = async (method, ctx) => {
                    const fn = cli.router.routes[method];
                    if (!fn)
                        throw new Error(`Method ${method} not found`);
                    const out = {
                        Method: method,
                    };
                    try {
                        const validator = fn.req.validator('object');
                        const error = validator(cli.request);
                        if (error)
                            throw error;
                        out.Validation = 'OK';
                    }
                    catch (error) {
                        out.Validation = 'Failed';
                        out.ValidationError = (0, util_1.formatError)(error);
                    }
                    out.Request = cli.request;
                    cli.stdout.write((0, toTree_1.toTree)(out) + '\n');
                    cli.exit(0);
                };
            }
        })();
    }
}
exports.CliParamPlan = CliParamPlan;
