"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamNum = void 0;
const json_patch_1 = require("../../json-patch");
const json_pointer_1 = require("../../json-pointer");
class CliParamNum {
    constructor() {
        this.param = 'num';
        this.short = 'n';
        this.title = 'Set number value';
        this.example = '--n/foo=123';
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onRequest = async () => {
                    const value = Number(JSON.parse(String(rawValue)));
                    const path = (0, json_pointer_1.toPath)(pointer);
                    cli.request = (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
                };
            }
        })();
    }
}
exports.CliParamNum = CliParamNum;
