"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamFile = void 0;
const json_patch_1 = require("../../json-patch");
const json_pointer_1 = require("../../json-pointer");
const fs_1 = require("fs");
class CliParamFile {
    constructor() {
        this.param = 'file';
        this.short = 'f';
        this.title = 'Read value from file';
        this.example = '--f/foo=test.json:json:/a/b/c';
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onRequest = async () => {
                    const [filename, fileCodec, filePointer] = String(rawValue).split(':');
                    const codec = fileCodec ? cli.codecs.get(fileCodec) : cli.requestCodec;
                    const uint8 = await fs_1.promises.readFile(filename);
                    let value = codec.decode(uint8);
                    if (filePointer) {
                        (0, json_pointer_1.validateJsonPointer)(filePointer);
                        value = (0, json_pointer_1.find)(value, (0, json_pointer_1.toPath)(filePointer)).val;
                    }
                    (0, json_pointer_1.validateJsonPointer)(pointer);
                    const path = (0, json_pointer_1.toPath)(pointer);
                    (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value }], { mutate: true });
                };
            }
        })();
    }
}
exports.CliParamFile = CliParamFile;
