"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defineBuiltinRoutes = void 0;
const defineBuiltinRoutes = (router) => {
    const router2 = router.extend(({ t }) => ({
        '.echo': t
            .Function(t.any, t.any)
            .options({
            title: 'Echo input',
            description: 'Echo the input value back to the caller',
        })
            .implement(async (req) => {
            return req;
        }),
        '.type': t
            .Function(t.undef, t.any)
            .options({
            title: 'Type information',
            description: 'Returns whole type system of this CLI.',
        })
            .implement(async (request, ctx) => {
            return ctx.cli.types.exportTypes();
        }),
    }));
    return router2;
};
exports.defineBuiltinRoutes = defineBuiltinRoutes;
