"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliCodecMsgpack = void 0;
const msgpack_1 = require("../../json-pack/msgpack");
const MsgPackDecoder_1 = require("../../json-pack/msgpack/MsgPackDecoder");
class CliCodecMsgpack {
    constructor(writer) {
        this.writer = writer;
        this.id = 'msgpack';
        this.description = 'MessagePack codec';
        this.encoder = new msgpack_1.MsgPackEncoder(writer);
        this.decoder = new MsgPackDecoder_1.MsgPackDecoder();
    }
    encode(value) {
        return this.encoder.encode(value);
    }
    decode(bytes) {
        return this.decoder.read(bytes);
    }
}
exports.CliCodecMsgpack = CliCodecMsgpack;
