"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliCodecJson = void 0;
const JsonDecoder_1 = require("../../json-pack/json/JsonDecoder");
const JsonEncoder_1 = require("../../json-pack/json/JsonEncoder");
class CliCodecJson {
    constructor(writer) {
        this.writer = writer;
        this.id = 'json';
        this.description = 'JSON codec, which also supports binary data';
        this.encoder = new JsonEncoder_1.JsonEncoder(writer);
        this.decoder = new JsonDecoder_1.JsonDecoder();
    }
    encode(value) {
        return this.encoder.encode(value);
    }
    decode(bytes) {
        return this.decoder.read(bytes);
    }
}
exports.CliCodecJson = CliCodecJson;
