/// <reference types="node" />
import { TypeSystem } from '../json-type/system/TypeSystem';
import { RoutesBase, TypeRouter } from '../json-type/system/TypeRouter';
import { TypeRouterCaller } from '../reactive-rpc/common/rpc/caller/TypeRouterCaller';
import type { CliCodecs } from './CliCodecs';
import type { TypeBuilder } from '../json-type/type/TypeBuilder';
import type { WriteStream, ReadStream } from 'tty';
import type { CliCodec, CliParam, CliParamInstance } from './types';
export interface CliOptions<Router extends TypeRouter<any>> {
    codecs: CliCodecs;
    params?: CliParam[];
    router?: Router;
    version?: string;
    cmd?: string;
    argv?: string[];
    stdout?: WriteStream;
    stderr?: WriteStream;
    stdin?: ReadStream;
    exit?: (errno: number) => void;
}
export declare class Cli<Router extends TypeRouter<RoutesBase> = TypeRouter<RoutesBase>> {
    readonly options: CliOptions<Router>;
    router: Router;
    readonly params: CliParam[];
    readonly paramMap: Map<string, CliParam>;
    readonly types: TypeSystem;
    readonly t: TypeBuilder;
    readonly caller: TypeRouterCaller<Router>;
    readonly codecs: CliCodecs;
    request?: unknown;
    response?: unknown;
    argv: string[];
    stdout: WriteStream;
    stderr: WriteStream;
    stdin: ReadStream;
    exit: (errno: number) => void;
    requestCodec: CliCodec;
    responseCodec: CliCodec;
    rawStdinInput?: Uint8Array;
    stdinInput?: unknown;
    protected paramInstances: CliParamInstance[];
    constructor(options: CliOptions<Router>);
    run(): void;
    param(param: string): CliParam | undefined;
    runAsync(): Promise<void>;
    cmd(): string;
    private getStdin;
    private readStdin;
}
