"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpUndefined = void 0;
const AbstractPredicateOp_1 = require("./AbstractPredicateOp");
const json_pointer_1 = require("../../json-pointer");
class OpUndefined extends AbstractPredicateOp_1.AbstractPredicateOp {
    constructor(path) {
        super(path);
    }
    op() {
        return 'undefined';
    }
    code() {
        return 38;
    }
    test(doc) {
        try {
            const { val } = (0, json_pointer_1.find)(doc, this.path);
            const test = val === undefined;
            return test;
        }
        catch (error) {
            if (error.message === 'NOT_FOUND')
                return true;
            throw error;
        }
    }
    toJson(parent) {
        const op = {
            op: 'undefined',
            path: (0, json_pointer_1.formatJsonPointer)(parent ? this.path.slice(parent.path.length) : this.path),
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'undefined' : 38;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(2);
        encoder.writer.u8(38);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
    }
}
exports.OpUndefined = OpUndefined;
