"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpTest = void 0;
const json_pointer_1 = require("../../json-pointer");
const AbstractPredicateOp_1 = require("./AbstractPredicateOp");
const deepEqual_1 = require("../../json-equal/deepEqual");
class OpTest extends AbstractPredicateOp_1.AbstractPredicateOp {
    constructor(path, value, not) {
        super(path);
        this.value = value;
        this.not = not;
    }
    op() {
        return 'test';
    }
    code() {
        return 5;
    }
    test(doc) {
        const { val } = (0, json_pointer_1.find)(doc, this.path);
        if (val === undefined)
            return !!this.not;
        const test = (0, deepEqual_1.deepEqual)(val, this.value);
        return this.not ? !test : test;
    }
    toJson(parent) {
        const op = {
            op: 'test',
            path: (0, json_pointer_1.formatJsonPointer)(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        if (this.not)
            op.not = this.not;
        return op;
    }
    toCompact(parent, verbose) {
        const path = parent ? this.path.slice(parent.path.length) : this.path;
        const opcode = verbose ? 'test' : 5;
        return this.not ? [opcode, path, this.value, 1] : [opcode, path, this.value];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(this.not ? 4 : 3);
        encoder.writer.u8(5);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeAny(this.value);
        if (this.not)
            encoder.writer.u8(1);
    }
}
exports.OpTest = OpTest;
