import type { CompactIncOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationInc } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpInc extends AbstractOp<'inc'> {
    readonly inc: number;
    constructor(path: Path, inc: number);
    op(): "inc";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: unknown;
    };
    toJson(parent?: AbstractOp): OperationInc;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactIncOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
