import type { CompactInOp } from '../codec/compact/types';
import { OperationIn } from '../types';
import { Path } from '../../json-pointer';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { OPCODE } from '../constants';
import { AbstractOp } from './AbstractOp';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpIn extends AbstractPredicateOp<'in'> {
    readonly value: unknown[];
    constructor(path: Path, value: unknown[]);
    op(): "in";
    code(): OPCODE;
    test(doc: unknown): boolean;
    toJson(parent?: AbstractOp): OperationIn;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactInOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
