"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyPatch = exports.applyOps = exports.applyOp = void 0;
const clone_1 = require("../../json-clone/clone");
const json_1 = require("../codec/json");
function applyOp(doc, op, mutate) {
    if (!mutate)
        doc = (0, clone_1.clone)(doc);
    return op.apply(doc);
}
exports.applyOp = applyOp;
function applyOps(doc, ops, mutate) {
    if (!mutate)
        doc = (0, clone_1.clone)(doc);
    const res = [];
    const length = ops.length;
    for (let i = 0; i < length; i++) {
        const opResult = ops[i].apply(doc);
        doc = opResult.doc;
        res.push(opResult);
    }
    return { doc, res };
}
exports.applyOps = applyOps;
function applyPatch(doc, patch, options) {
    const result = applyOps(doc, (0, json_1.decode)(patch, options), options.mutate);
    return result;
}
exports.applyPatch = applyPatch;
