"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.xStrIns = void 0;
const json_1 = require("../../json-patch/codec/json");
const op_1 = require("../../json-patch/op");
const xStrIns = (ins, op) => {
    if (op instanceof op_1.OpStrIns) {
        if (ins.pos > op.pos)
            return op;
        return (0, json_1.operationToOp)({ ...op.toJson(), pos: op.pos + ins.str.length }, {});
    }
    else if (op instanceof op_1.OpStrDel) {
        const del = op;
        if (del.pos < ins.pos) {
            const deleteLength = typeof del.str === 'string' ? del.str.length : del.len;
            if (del.pos + deleteLength > ins.pos) {
                const beforeLength = ins.pos - del.pos;
                if (typeof del.str === 'string') {
                    return [
                        (0, json_1.operationToOp)({ ...del.toJson(), pos: ins.pos + ins.str.length, str: del.str.substr(beforeLength) }, {}),
                        (0, json_1.operationToOp)({ ...del.toJson(), pos: del.pos, str: del.str.substr(0, beforeLength) }, {}),
                    ];
                }
                else {
                    return [
                        (0, json_1.operationToOp)({ ...del.toJson(), pos: ins.pos + ins.str.length, len: deleteLength - beforeLength }, {}),
                        (0, json_1.operationToOp)({ ...del.toJson(), pos: del.pos, len: beforeLength }, {}),
                    ];
                }
            }
        }
        if (ins.pos < del.pos)
            return (0, json_1.operationToOp)({ ...op.toJson(), pos: op.pos + ins.str.length }, {});
        return op;
    }
    return op;
};
exports.xStrIns = xStrIns;
