"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.xMove = void 0;
const json_1 = require("../../json-patch/codec/json");
const json_pointer_1 = require("../../json-pointer");
const xMove = (move, op) => {
    if ((0, json_pointer_1.isRoot)(move.path))
        return op;
    if ((0, json_pointer_1.isChild)(move.from, op.path)) {
        const pointer = [...move.path, ...op.path.slice(move.path.length)];
        const operation = op.toJson();
        operation.path = pointer;
        return (0, json_1.operationToOp)(operation, {});
    }
    return op;
};
exports.xMove = xMove;
