"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transform = void 0;
const transforms_1 = require("./transforms");
const transform = (accepted, proposed) => {
    const length = accepted.length;
    for (let i = 0; i < length; i++) {
        const against = accepted[i];
        const transformFunction = transforms_1.xforms[against.op()];
        if (transformFunction) {
            const transformed = [];
            for (const op of proposed) {
                const newOps = transformFunction(against, op);
                if (Array.isArray(newOps))
                    transformed.push(...newOps);
                else if (newOps)
                    transformed.push(newOps);
            }
            proposed = transformed;
        }
    }
    return proposed;
};
exports.transform = transform;
