import type { IWriter, IWriterGrowable } from '../../util/buffers';
import type { BinaryJsonEncoder, StreamingBinaryJsonEncoder } from '../types';
export declare class UbjsonEncoder implements BinaryJsonEncoder, StreamingBinaryJsonEncoder {
    readonly writer: IWriter & IWriterGrowable;
    constructor(writer: IWriter & IWriterGrowable);
    encode(value: unknown): Uint8Array;
    writeAny(value: unknown): void;
    writeNull(): void;
    writeUndef(): void;
    writeBoolean(bool: boolean): void;
    writeNumber(num: number): void;
    writeInteger(int: number): void;
    writeUInteger(uint: number): void;
    writeFloat(float: number): void;
    writeBigInt(int: bigint): void;
    writeBin(buf: Uint8Array): void;
    writeStr(str: string): void;
    writeAsciiStr(str: string): void;
    writeArr(arr: unknown[]): void;
    writeStartArr(): void;
    writeEndArr(): void;
    writeObj(obj: Record<string, unknown>): void;
    writeKey(str: string): void;
    writeStartObj(): void;
    writeEndObj(): void;
}
