"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.objectOperators = void 0;
const tslib_1 = require("tslib");
const util = tslib_1.__importStar(require("../util"));
const codegen_steps_1 = require("../codegen-steps");
exports.objectOperators = [
    [
        'keys',
        [],
        1,
        (expr, ctx) => {
            const operand = ctx.eval(expr[1], ctx);
            return util.keys(operand);
        },
        (ctx) => {
            ctx.link(util.keys, 'keys');
            const js = `keys(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'values',
        [],
        1,
        (expr, ctx) => {
            const operand = ctx.eval(expr[1], ctx);
            return util.values(operand);
        },
        (ctx) => {
            ctx.link(util.values, 'values');
            const js = `values(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'entries',
        [],
        1,
        (expr, ctx) => {
            const operand = ctx.eval(expr[1], ctx);
            return util.entries(operand);
        },
        (ctx) => {
            ctx.link(util.entries, 'entries');
            const js = `entries(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
];
