"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VecNode = void 0;
const ConNode_1 = require("../con/ConNode");
const printTree_1 = require("../../../util/print/printTree");
const clock_1 = require("../../../json-crdt-patch/clock");
class VecNode {
    constructor(doc, id) {
        this.doc = doc;
        this.id = id;
        this.elements = [];
        this._view = [];
        this.api = undefined;
    }
    val(index) {
        return this.elements[index];
    }
    get(index) {
        const id = this.elements[index];
        if (!id)
            return undefined;
        return this.doc.index.get(id);
    }
    put(index, id) {
        if (index > 255)
            throw new Error('OUT_OF_BOUNDS');
        const currentId = this.val(index);
        if (currentId && (0, clock_1.compare)(currentId, id) >= 0)
            return;
        if (index > this.elements.length)
            for (let i = this.elements.length; i < index; i++)
                this.elements.push(undefined);
        if (index < this.elements.length)
            this.elements[index] = id;
        else
            this.elements.push(id);
        return currentId;
    }
    ext() {
        if (this.__extNode)
            return this.__extNode;
        const extensionId = this.getExtId();
        const isExtension = extensionId >= 0;
        if (!isExtension)
            return undefined;
        const extension = this.doc.ext.get(extensionId);
        if (!extension)
            return undefined;
        this.__extNode = new extension.Node(this.get(1));
        return this.__extNode;
    }
    isExt() {
        return !!this.ext();
    }
    getExtId() {
        if (this.elements.length !== 2)
            return -1;
        const type = this.get(0);
        if (!(type instanceof ConNode_1.ConNode))
            return -1;
        const buf = type.val;
        const id = this.id;
        if (!(buf instanceof Uint8Array) || buf.length !== 3 || buf[1] !== id.sid % 256 || buf[2] !== id.time % 256)
            return -1;
        return buf[0];
    }
    child() {
        return this.ext();
    }
    container() {
        return this;
    }
    children(callback) {
        if (this.isExt())
            return;
        const elements = this.elements;
        const length = elements.length;
        const index = this.doc.index;
        for (let i = 0; i < length; i++) {
            const id = elements[i];
            if (!id)
                continue;
            const node = index.get(id);
            if (node)
                callback(node);
        }
    }
    view() {
        const extNode = this.ext();
        if (extNode)
            return extNode.view();
        let useCache = true;
        const _view = this._view;
        const arr = [];
        const index = this.doc.index;
        const elements = this.elements;
        const length = elements.length;
        for (let i = 0; i < length; i++) {
            const id = elements[i];
            const node = id ? index.get(id) : undefined;
            const value = node ? node.view() : undefined;
            if (_view[i] !== value)
                useCache = false;
            arr.push(value);
        }
        return useCache ? _view : (this._view = arr);
    }
    toString(tab = '') {
        const extNode = this.ext();
        const header = this.constructor.name + ' ' + (0, clock_1.toDisplayString)(this.id) + (extNode ? ` { extension = ${this.getExtId()} }` : '');
        if (extNode) {
            return this.child().toString(tab);
        }
        return (header +
            (0, printTree_1.printTree)(tab, [
                ...this.elements.map((id, i) => (tab) => `${i}: ${!id ? 'nil' : this.doc.index.get(id).toString(tab + '  ' + ' '.repeat(('' + i).length))}`),
                ...(extNode ? [(tab) => `${this.child().toString(tab)}`] : []),
            ]));
    }
}
exports.VecNode = VecNode;
