"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConNode = void 0;
const clock_1 = require("../../../json-crdt-patch/clock");
class ConNode {
    constructor(id, val) {
        this.id = id;
        this.val = val;
        this.api = undefined;
    }
    children() { }
    child() {
        return undefined;
    }
    container() {
        return undefined;
    }
    view() {
        return this.val;
    }
    toString(tab) {
        const val = this.val;
        const valFormatted = val instanceof Uint8Array
            ? `Uint8Array { ${('' + val).replaceAll(',', ', ')} }`
            : `{ ${val instanceof clock_1.Timestamp ? (0, clock_1.toDisplayString)(val) : JSON.stringify(val)} }`;
        return `${this.constructor.name} ${(0, clock_1.toDisplayString)(this.id)} ${valFormatted}`;
    }
}
exports.ConNode = ConNode;
