import { AbstractRga, Chunk } from '../rga/AbstractRga';
import { ITimestampStruct } from '../../../json-crdt-patch/clock';
import { Model } from '../../model';
import type { JsonNode, JsonNodeView } from '..';
import type { Printable } from '../../../util/print/types';
type E = ITimestampStruct;
export declare class ArrChunk implements Chunk<E[]> {
    readonly id: ITimestampStruct;
    span: number;
    del: boolean;
    data: E[] | undefined;
    len: number;
    p: ArrChunk | undefined;
    l: ArrChunk | undefined;
    r: ArrChunk | undefined;
    p2: ArrChunk | undefined;
    l2: ArrChunk | undefined;
    r2: ArrChunk | undefined;
    s: ArrChunk | undefined;
    constructor(id: ITimestampStruct, span: number, data: E[] | undefined);
    merge(data: E[]): void;
    split(ticks: number): ArrChunk;
    delete(): void;
    clone(): ArrChunk;
}
export declare class ArrNode<Element extends JsonNode = JsonNode> extends AbstractRga<E[]> implements JsonNode<Readonly<JsonNodeView<Element>[]>>, Printable {
    readonly doc: Model<any>;
    constructor(doc: Model<any>, id: ITimestampStruct);
    get(position: number): E | undefined;
    getNode(position: number): JsonNode | undefined;
    getById(id: ITimestampStruct): E | undefined;
    createChunk(id: ITimestampStruct, data: E[] | undefined): ArrChunk;
    protected onChange(): void;
    protected toStringName(): string;
    child(): undefined;
    container(): JsonNode | undefined;
    private _tick;
    private _view;
    view(): Readonly<JsonNodeView<Element>[]>;
    children(callback: (node: JsonNode) => void): void;
    api: undefined | unknown;
    protected printChunk(tab: string, chunk: ArrChunk): string;
}
export {};
