import * as nodes from '../../../nodes';
import { ClockTable } from '../../../../json-crdt-patch/codec/clock/ClockTable';
import { CrdtReader } from '../../../../json-crdt-patch/util/binary/CrdtReader';
import { IndexedFields, IndexedNodeFields } from './types';
import { ITimestampStruct, IVectorClock } from '../../../../json-crdt-patch/clock';
import { Model } from '../../../model/Model';
import { CborDecoderBase } from '../../../../json-pack/cbor/CborDecoderBase';
export declare class Decoder {
    readonly dec: CborDecoderBase<CrdtReader>;
    protected doc: Model;
    protected clockTable?: ClockTable;
    constructor(reader?: CrdtReader);
    decode<M extends Model>(fields: IndexedFields, ModelConstructor?: new (clock: IVectorClock) => M): M;
    decodeFields<M extends Model>(clockTable: ClockTable, fields: IndexedNodeFields, ModelConstructor?: new (clock: IVectorClock) => M): M;
    protected ts(): ITimestampStruct;
    protected decodeNode(id: ITimestampStruct): nodes.JsonNode;
    decodeCon(id: ITimestampStruct, length: number): nodes.ConNode;
    decodeVal(id: ITimestampStruct): nodes.ValNode;
    decodeObj(id: ITimestampStruct, length: number): nodes.ObjNode;
    decodeVec(id: ITimestampStruct, length: number): nodes.VecNode;
    protected decodeStr(id: ITimestampStruct, length: number): nodes.StrNode;
    private decodeStrChunk;
    protected decodeBin(id: ITimestampStruct, length: number): nodes.BinNode;
    private decodeBinChunk;
    protected decodeArr(id: ITimestampStruct, length: number): nodes.ArrNode;
    private decodeArrChunk;
}
