"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const json_pointer_1 = require("../json-pointer");
try {
    const buf = (0, fs_1.readFileSync)(0);
    const doc = JSON.parse(buf.toString());
    const result = (0, json_pointer_1.findByPointer)(process.argv[2], doc);
    const value = result.val;
    if (value === undefined) {
        if (Array.isArray(result.obj))
            throw 'INVALID_INDEX';
        throw 'NOT_FOUND';
    }
    process.stdout.write(JSON.stringify(value, null, 4) + '\n');
}
catch (error) {
    process.stderr.write(error + '\n');
    process.exit(1);
}
