"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const json_pointer_testCases_1 = require("./json-pointer-testCases");
const deepEqual_1 = require("../json-equal/deepEqual");
const bin = String(process.argv[2]);
if (!bin) {
    console.error('First argument should be argument to json-patch binary.');
    process.exit(1);
}
console.log('');
console.log(`Running JSON Pointer tests.`);
console.log('');
let cntCorrect = 0;
let cntFailed = 0;
for (const { name, doc, pointer, result, error } of json_pointer_testCases_1.testCases) {
    const { stdout, stderr } = (0, child_process_1.spawnSync)(bin, [pointer], { input: JSON.stringify(doc) });
    let isCorrect = false;
    if (error === undefined) {
        isCorrect = (0, deepEqual_1.deepEqual)(result, JSON.parse(stdout.toString()));
    }
    else {
        const errorMessage = stderr.toString().trim();
        isCorrect = errorMessage === error;
    }
    if (isCorrect) {
        cntCorrect++;
        console.log('✅ ' + name);
    }
    else {
        cntFailed++;
        console.error('🛑 ' + name);
    }
}
console.log('');
console.log(`Successful = ${cntCorrect}, Failed = ${cntFailed}, Total = ${json_pointer_testCases_1.testCases.length}`);
console.log('');
if (cntFailed > 0)
    process.exit(1);
