"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const json_patch_1 = require("../json-patch");
const deepEqual_1 = require("../json-equal/deepEqual");
const suites_1 = require("./test/suites");
const bin = String(process.argv[2]);
if (!bin) {
    console.error('First argument should be argument to json-patch binary.');
    process.exit(1);
}
let cntCorrect = 0;
let cntFailed = 0;
suites_1.testSuites.forEach((suite) => {
    console.log('');
    console.log(suite.name);
    console.log('');
    suite.tests.forEach((test) => {
        if (test.disabled)
            return;
        const testName = test.comment || test.error || JSON.stringify(test.patch);
        if (test.expected !== undefined) {
            test.patch.forEach(json_patch_1.validateOperation);
            let isCorrect = false;
            let result;
            try {
                const input = JSON.stringify(test.doc);
                const { stdout } = (0, child_process_1.spawnSync)(bin, [JSON.stringify(test.patch)], { input });
                result = JSON.parse(stdout.toString());
                isCorrect = (0, deepEqual_1.deepEqual)(result, test.expected);
            }
            catch {
                isCorrect = false;
            }
            if (isCorrect) {
                cntCorrect++;
                console.log('✅ ' + testName);
            }
            else {
                cntFailed++;
                console.error('🛑 ' + testName);
                console.log('Expected:');
                console.log(test.expected);
                console.log('Received:');
                console.log(result);
            }
        }
        else if (test.error) {
            const input = JSON.stringify(test.doc);
            const { status, stdout, stderr } = (0, child_process_1.spawnSync)(bin, [JSON.stringify(test.patch)], { input });
            let isCorrect = true;
            if (status === 0)
                isCorrect = false;
            const output = stderr.toString().trim() || stdout.toString().trim();
            if (output !== test.error)
                isCorrect = false;
            if (!isCorrect) {
                cntFailed++;
                console.error('🛑 ' + testName);
                if (output !== test.error) {
                    console.error('Expected: ', test.error);
                    console.error('Received: ', output);
                }
            }
            else {
                cntCorrect++;
                console.log('✅ ' + testName);
            }
        }
        else {
            throw new Error('invalid test case');
        }
        if (cntFailed)
            process.exit(1);
    });
});
console.log('');
console.log(`Successful = ${cntCorrect}, Failed = ${cntFailed}, Total = ${cntCorrect + cntFailed}`);
console.log('');
if (cntFailed > 0)
    process.exit(1);
