"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Branch = exports.BasicBlock = void 0;
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
class BasicBlock {
    constructor(version, model) {
        this.model = model;
        this.v$ = new rxjs_1.BehaviorSubject(version);
    }
    fork() {
        return new BasicBlock(this.v$.getValue(), this.model.fork());
    }
    data$() {
        return this.v$.pipe((0, operators_1.switchMap)(() => (0, rxjs_1.of)(this.model.getData())));
    }
    getData() {
        return this.model.getData();
    }
    apply(patch) {
        this.model.apply(patch);
        this.v$.next(this.v$.getValue());
    }
}
exports.BasicBlock = BasicBlock;
class Branch {
    constructor(base) {
        this.batches = [];
        this.base$ = new rxjs_1.BehaviorSubject(base);
        this.patches = [];
        this.head$ = new rxjs_1.BehaviorSubject(base.fork());
    }
    cutBatch() {
        this.batches.push(this.patches);
        this.patches = [];
    }
    commit(patch) {
        this.patches.push(patch);
        this.head$.getValue().apply(patch);
    }
    rebase(patches) {
        const base = this.base$.getValue();
        for (const patch of patches)
            base.apply(patch);
        const head = base.fork();
        for (const patch of this.patches)
            head.apply(patch);
        this.head$.next(head);
    }
    reset(base) {
        this.base$.next(base);
        const patches = this.patches;
        this.patches = [];
        this.head$.next(base.fork());
        return patches;
    }
}
exports.Branch = Branch;
