import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _createSuper from "@babel/runtime/helpers/esm/createSuper";
import AbstractCalculator from './calculator';
const CALC_UNIT = 'CALC_UNIT';
function unit(value) {
  if (typeof value === 'number') {
    return `${value}${CALC_UNIT}`;
  }
  return value;
}
let CSSCalculator = /*#__PURE__*/function (_AbstractCalculator) {
  _inherits(CSSCalculator, _AbstractCalculator);
  var _super = _createSuper(CSSCalculator);
  function CSSCalculator(num) {
    var _this;
    _classCallCheck(this, CSSCalculator);
    _this = _super.call(this);
    _this.result = '';
    if (num instanceof CSSCalculator) {
      _this.result = `(${num.result})`;
    } else if (typeof num === 'number') {
      _this.result = unit(num);
    } else if (typeof num === 'string') {
      _this.result = num;
    }
    return _this;
  }
  _createClass(CSSCalculator, [{
    key: "add",
    value: function add(num) {
      if (num instanceof CSSCalculator) {
        this.result = `${this.result} + ${num.getResult()}`;
      } else if (typeof num === 'number' || typeof num === 'string') {
        this.result = `${this.result} + ${unit(num)}`;
      }
      this.lowPriority = true;
      return this;
    }
  }, {
    key: "sub",
    value: function sub(num) {
      if (num instanceof CSSCalculator) {
        this.result = `${this.result} - ${num.getResult()}`;
      } else if (typeof num === 'number' || typeof num === 'string') {
        this.result = `${this.result} - ${unit(num)}`;
      }
      this.lowPriority = true;
      return this;
    }
  }, {
    key: "mul",
    value: function mul(num) {
      if (this.lowPriority) {
        this.result = `(${this.result})`;
      }
      if (num instanceof CSSCalculator) {
        this.result = `${this.result} * ${num.getResult(true)}`;
      } else if (typeof num === 'number' || typeof num === 'string') {
        this.result = `${this.result} * ${num}`;
      }
      this.lowPriority = false;
      return this;
    }
  }, {
    key: "div",
    value: function div(num) {
      if (this.lowPriority) {
        this.result = `(${this.result})`;
      }
      if (num instanceof CSSCalculator) {
        this.result = `${this.result} / ${num.getResult(true)}`;
      } else if (typeof num === 'number' || typeof num === 'string') {
        this.result = `${this.result} / ${num}`;
      }
      this.lowPriority = false;
      return this;
    }
  }, {
    key: "getResult",
    value: function getResult(force) {
      return this.lowPriority || force ? `(${this.result})` : this.result;
    }
  }, {
    key: "equal",
    value: function equal(options) {
      const {
        unit: cssUnit = true
      } = options || {};
      const regexp = new RegExp(`${CALC_UNIT}`, 'g');
      this.result = this.result.replace(regexp, cssUnit ? 'px' : '');
      if (typeof this.lowPriority !== 'undefined') {
        return `calc(${this.result})`;
      }
      return this.result;
    }
  }]);
  return CSSCalculator;
}(AbstractCalculator);
export { CSSCalculator as default };