"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uiUtils = exports.generator = void 0;
const path_browserify_1 = __importDefault(require("path-browserify"));
function* infinite() {
    let index = 0;
    let timestamp = (new Date()).valueOf();
    const g = () => `${timestamp}_${index}`;
    while (true) {
        index++;
        yield g();
    }
    return g();
}
exports.generator = infinite();
function generateUniqueId() {
    return exports.generator.next().value;
}
function generateUniqueFilename(fileName) {
    const p = path_browserify_1.default.parse(fileName);
    return `${generateUniqueId()}${p.ext}`;
}
exports.uiUtils = {
    generateUniqueId,
    generateUniqueFilename
};
