"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSocket = exports.createSocket = exports.SocketController = void 0;
const react_1 = __importDefault(require("react"));
const socket_io_client_1 = require("socket.io-client");
class SocketController {
}
exports.SocketController = SocketController;
function createSocket(opts) {
    const socket = react_1.default.useRef((0, socket_io_client_1.io)({
        path: '/app-socket',
        autoConnect: false,
        auth(cb) {
            cb({});
        },
    }));
    const roomsRef = react_1.default.useRef({});
    react_1.default.useEffect(() => {
        const handler = () => {
            console.log('Connected to server');
            joinRoom();
        };
        socket.current.on('connect', handler);
        return () => {
            socket.current.off('connect', handler);
        };
    }, []);
    const connect = react_1.default.useCallback(() => {
        socket.current.connect();
        return () => {
            socket.current.disconnect();
        };
    }, []);
    const leaveRoom = react_1.default.useCallback((roomIds) => {
        if (roomIds) {
            if (typeof roomIds === 'string') {
                roomIds = [roomIds];
            }
            for (const room of roomIds) {
                roomsRef.current[room] = undefined;
            }
            socket.current.emit('/__magicjs/rooms/leave', roomIds);
        }
    }, []);
    const joinRoom = react_1.default.useCallback((rooms) => {
        if (rooms) {
            if (typeof rooms === 'string') {
                rooms = [rooms];
            }
            for (const room of rooms) {
                roomsRef.current[room] = true;
            }
        }
        const roomIds = Object.keys(roomsRef.current).filter((k) => roomsRef.current[k] === true);
        if (roomIds.length > 0) {
            socket.current.emit('/__magicjs/rooms/join', roomIds);
        }
        return () => {
            return leaveRoom(roomIds);
        };
    }, []);
    /**
     * @returns Unsubscribe function (removes event listener)
     */
    const subscribe = react_1.default.useCallback((ev, listener) => {
        socket.current.on(ev, listener);
        return () => socket.current.off(ev, listener);
    }, []);
    react_1.default.useEffect(() => {
        connect();
    }, [connect]);
    return {
        connect,
        socket,
        subscribe,
        joinRoom,
        leaveRoom
    };
}
exports.createSocket = createSocket;
function useSocket() {
}
exports.useSocket = useSocket;
