import React from 'react';
import { BackendRemote } from './backend';
import { Axios } from 'axios';
import { SocketApi, SocketController } from './socket';
export declare const generator: Generator<string, string, unknown>;
type RoleMapping = {
    userId: string;
    role: string;
};
type Context = {
    token: string;
    isAuthenticated: boolean;
    currentUser: any;
    roles: RoleMapping[];
};
export declare class FrontendController {
    static instance: FrontendController;
    static getInstance(): FrontendController;
    registeredComponents: any[];
    arkConfig: any;
    context: {
        token: any;
        isAuthenticated: boolean;
        currentUser: any;
    };
    map: any;
    applets: any[];
    client: Axios;
    socketController: SocketController;
    subscribe(event: string, handler: any): () => void;
    emit(event: string, ...args: any[]): Promise<void>;
    refreshContext(): Promise<void>;
    setAuthCookie(v: any): void;
    constructor();
}
export declare const backend: BackendRemote;
export declare const controllerRef: FrontendController;
export declare const ControllerContext: React.Context<FrontendController>;
export declare const SocketContext: React.Context<SocketApi>;
export declare function useLogin(): {
    current: Context;
    logout: () => Promise<import("axios").AxiosResponse<any, any>>;
    isCurrentUserInAnyRoles: (roles: string | string[]) => boolean;
};
export declare function useAxios(): Axios;
export declare function useController(): {
    controller: FrontendController;
};
export declare function useSocket(): SocketApi;
interface ReactComponent {
    (...props: any[]): any;
    getInitialState?: () => any;
}
export declare function createComponent(component: ReactComponent): ReactComponent;
export declare function registerView(path: string, id: string, Component: any): void;
export declare function registerApplet(meta: any, Component: any): void;
type RouteApi = {
    pathname: string;
    match?: any;
    component?: any;
    push: (path: string) => void;
    isInitialRender: boolean;
    getQuery: () => any;
};
export declare function attachRouteMeta(routeMeta: any, Comp: any): (props: any) => import("react/jsx-runtime").JSX.Element;
export declare function attachAppletMeta(appletMeta: any, Comp: any): (props: any) => import("react/jsx-runtime").JSX.Element;
export declare function useRouteMeta(): any;
export declare function useAppletMeta(): any;
export declare function useRoute(): RouteApi;
export declare function useParams(): any;
export type LinkDisplayProps = {
    pageId?: string;
    appletId?: string;
    params?: any;
    query?: any;
    children?: (props: {
        url: string;
    }) => JSX.Element;
};
export declare function LinkDisplay(props: LinkDisplayProps): JSX.Element;
export declare function Link(props: {
    to?: string;
    target?: React.HTMLAttributeAnchorTarget;
    children?: any;
    className?: string;
}): import("react/jsx-runtime").JSX.Element;
export declare function importUI(id: string): (props: any) => import("react/jsx-runtime").JSX.Element;
export declare function Applet(props: {
    id: string;
} & any): import("react/jsx-runtime").JSX.Element;
export declare function Mount(props: {
    path: string;
}): import("react/jsx-runtime").JSX.Element;
export type Mounts = {
    appletId: string;
    path: string;
    label: string;
    link: boolean;
    pageId: string;
};
export declare function useMounts(): {
    current: Mounts[];
};
export declare function Protected(props: any): any;
export declare function RedirectToLoginPage(): import("react/jsx-runtime").JSX.Element;
export declare function goBackToReturnPath(): void;
export declare function App(props: {
    initialPath?: any;
    helmetContext?: any;
    controller?: FrontendController;
}): import("react/jsx-runtime").JSX.Element;
export declare function startApp(): void;
export declare function loadConfig(config: any): {
    getValue(propertyName: string, defaultVal?: any): any;
};
export { createUploader, createSrc, UploadButton } from './file-uploader';
export { useContent } from './content';
export { CMSLog } from './content-core';
export { uiUtils } from './ui-utils';
export declare function waitInMs(timeourInMs: number): Promise<void>;
export { usePromise } from './use-promise';
