"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useContent = void 0;
const react_1 = __importStar(require("react"));
const content_core_1 = require("./content-core");
const isEqual_1 = __importDefault(require("lodash/isEqual"));
const cloneDeep_1 = __importDefault(require("lodash/cloneDeep"));
const traverse_1 = __importDefault(require("traverse"));
function useContent(opts_) {
    const opts = react_1.default.useMemo(() => {
        return Object.assign({
            serviceId: typeof opts_ === 'string' ? opts_ : undefined,
            defaultContent: {},
            useReduxStore: false,
            enableLocalStorage: false,
        }, typeof opts_ === 'object' ? opts_ : undefined);
    }, [opts_]);
    const localStorageKey = react_1.default.useMemo(() => {
        return `_cmsHook/_ls/${opts.serviceId}`;
    }, [opts.serviceId]);
    if (opts.enableLocalStorage === true) {
        try {
            opts.defaultContent = JSON.parse(localStorage.getItem(localStorageKey));
        }
        catch (e) {
            console.warn(`Failed to load content from local storage for '${opts.serviceId};`);
            console.warn(e);
        }
    }
    const [baseContent, setBaseContent] = (0, react_1.useState)(opts.defaultContent);
    const [content, setContentToState] = (0, react_1.useState)(opts.defaultContent);
    const [hasChanged, setHasChanged] = (0, react_1.useState)(false);
    react_1.default.useEffect(() => {
        setHasChanged((0, isEqual_1.default)(baseContent, content) === false);
    }, [baseContent, content]);
    let isBatchModeEnabled = false;
    let batchContent = null;
    const getCurrentValByKey = (key, ejectTraverseResult = false) => {
        const traverseResult = (0, traverse_1.default)(isBatchModeEnabled === true ? batchContent : content);
        const resolvedKey = (0, content_core_1.resolveAddressForTraversal)(traverseResult, key);
        if (ejectTraverseResult === true) {
            return {
                val: traverseResult.get(resolvedKey.split('.')),
                traverseResult,
                resolvedKey,
            };
        }
        return traverseResult.get(resolvedKey.split('.'));
    };
    const actionLogs = react_1.default.useRef([]);
    const updateKey = (key, val) => {
        let input = null;
        if (isBatchModeEnabled === true) {
            input = batchContent;
        }
        else {
            input = (0, cloneDeep_1.default)(content);
        }
        const result = content_core_1.CMS.updateContent(input, [
            {
                key,
                val,
            },
        ], 'edit');
        const output = result.content;
        actionLogs.current.push(...result.appliedActions);
        if (isBatchModeEnabled === true) {
            batchContent = output;
        }
        else {
            setContentToState(output);
        }
    };
    return {
        isAvailable: content !== null && content !== undefined,
        hasChanged,
        content,
        actionLogs,
        runBatch: (fn) => {
            isBatchModeEnabled = true;
            batchContent = (0, cloneDeep_1.default)(content);
            fn && fn(batchContent);
            isBatchModeEnabled = false;
            setContentToState(batchContent);
            batchContent = null;
        },
        reset: () => {
            setContentToState(baseContent);
            setHasChanged(false);
            actionLogs.current = [];
        },
        setContent: (val) => {
            setContentToState(val);
            setBaseContent(val);
            setHasChanged(false);
            actionLogs.current = [];
        },
        markAsSaved: () => {
            setBaseContent(content);
            setHasChanged(false);
            actionLogs.current = [];
        },
        getPendingLogs: () => {
            return actionLogs.current;
        },
        resetPendingLogs: () => {
            actionLogs.current = [];
        },
        insertItem: (key, indexToInsert, val) => {
            const item = getCurrentValByKey(key, true);
            const resolvedIndex = (0, content_core_1.resolveIndexFromTraversalResult)(item.traverseResult, item.resolvedKey, String(indexToInsert));
            if (Array.isArray(item.val)) {
                updateKey(key, [
                    ...item.val.slice(0, resolvedIndex),
                    val,
                    ...item.val.slice(resolvedIndex, item.val.length),
                ]);
            }
            else {
                throw new Error(`${key} is not an array. pushItem can be only called upon an array`);
            }
        },
        pushItem: (key, val) => {
            const item = getCurrentValByKey(key);
            updateKey(key, [...(item || []), val]);
        },
        unshiftItem: (key, val) => {
            const item = getCurrentValByKey(key);
            updateKey(key, [val, ...(item || [])]);
        },
        removeItemAt: (key, index) => {
            const item = getCurrentValByKey(key, true);
            const resolvedIndex = (0, content_core_1.resolveIndexFromTraversalResult)(item.traverseResult, item.resolvedKey, index);
            if (Array.isArray(item.val)) {
                updateKey(key, item.val.filter((x, i) => i !== resolvedIndex));
            }
            else {
                throw new Error(`${key} is not an array. unshiftItem can be only called upon an array`);
            }
        },
        updateKey,
        saveLocally: () => {
            try {
                window.localStorage.setItem(localStorageKey, JSON.stringify(content));
            }
            catch (e) {
                console.warn(`Failed to load content from local storage for '${opts.serviceId};`);
                console.warn(e);
            }
        },
        hasLocalData: () => {
            try {
                const data = JSON.parse(window.localStorage.getItem(localStorageKey));
                return data !== undefined && data !== null;
            }
            catch (e) {
                console.warn(`Failed to load content from local storage for '${opts.serviceId};`);
                console.warn(e);
            }
            return false;
        },
    };
}
exports.useContent = useContent;
