import { Configuration } from 'webpack';
import { BuilderBase, ConfigurationOptions } from './builder-base';
import { GhostFileActions } from './ghost-file';
/**
 * SPA Builder
 */
export declare class SPABuilder extends BuilderBase {
    private appFilePath;
    private appId;
    private virtualModules;
    /**
     * Creates a new SPA builder instance
     * @param {string} id
     * @param {string} appFilePath
     */
    constructor(id: string, appFilePath: string);
    /**
     * Get Ghost Files
     * @param {ConfigurationOptions} opts
     * @return {GhostFileActions[]}
     */
    getGhostFiles(opts: ConfigurationOptions): GhostFileActions[];
    initCompiler(opts: ConfigurationOptions): void;
    /**
     * @param {ConfigurationOptions} opts
     * @return {Configuration}
     */
    getConfiguration({ cwd, mode }: ConfigurationOptions): Configuration;
}
