import { Configuration } from 'webpack';
import { BuilderBase, ConfigurationOptions } from './builder-base';
/**
 * Backend Builder
 */
export declare class BackendBuilder extends BuilderBase {
    private entryFilePath;
    private virtualModules;
    /**
     * Creates a new backend builder instance
     * @param {string} entryFilePath
     */
    constructor(entryFilePath: string);
    initCompiler(opts: ConfigurationOptions): void;
    /**
     * @param {ConfigurationOptions} opts
     * @return {Configuration}
     */
    getConfiguration({ cwd, mode }: ConfigurationOptions): Configuration;
}
