"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.publish = void 0;
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const tar_fs_1 = __importDefault(require("tar-fs"));
const form_data_1 = __importDefault(require("form-data"));
const axios_1 = __importDefault(require("axios"));
function publish(featureName, secretKey) {
    return __awaiter(this, void 0, void 0, function* () {
        const cwd = process.cwd();
        const TEMP_FOLDER = path_1.default.join(cwd, '.temp');
        const TARGET_TAR_FILE_PATH = path_1.default.join(TEMP_FOLDER, 'archive.tar.gz');
        const FEATURE_SOURCE_DIR = path_1.default.join(cwd, 'src', 'features', featureName);
        if (!fs_extra_1.default.existsSync(FEATURE_SOURCE_DIR)) {
            throw new Error(`feature '${featureName}' does not exist`);
        }
        if (fs_extra_1.default.existsSync(TEMP_FOLDER)) {
            fs_extra_1.default.emptyDirSync(TEMP_FOLDER);
        }
        else {
            fs_extra_1.default.mkdirSync(TEMP_FOLDER, { recursive: true });
        }
        let config = null;
        const CONFIG_FILE_PATH = path_1.default.join(FEATURE_SOURCE_DIR, 'config.json');
        if (!fs_extra_1.default.existsSync(CONFIG_FILE_PATH)) {
            throw new Error(`config does not found`);
        }
        try {
            config = JSON.parse(fs_extra_1.default.readFileSync(CONFIG_FILE_PATH, 'utf-8'));
        }
        catch (e) {
            throw new Error(`config should be a valid json`);
        }
        if (!config.packageId) {
            throw new Error(`packageId is invalid or not found`);
        }
        yield new Promise((resolve, reject) => {
            tar_fs_1.default.pack(FEATURE_SOURCE_DIR)
                .pipe(fs_extra_1.default.createWriteStream(TARGET_TAR_FILE_PATH))
                .on('finish', () => {
                resolve();
            })
                .on('error', reject);
        });
        const form = new form_data_1.default();
        form.append('archive', fs_extra_1.default.createReadStream(TARGET_TAR_FILE_PATH));
        form.append('config', JSON.stringify(config));
        const res = yield axios_1.default.post(`https://app.mern.ai/___service/compass/publishTemplate?packageId=${encodeURIComponent(config.packageId)}`, form, {
            headers: Object.assign(Object.assign({}, form.getHeaders()), { 'secretkey': secretKey })
        });
        fs_extra_1.default.emptyDirSync(TEMP_FOLDER);
        fs_extra_1.default.rmdirSync(TEMP_FOLDER);
        console.log('published');
    });
}
exports.publish = publish;
