"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.init = exports.createCommand = void 0;
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const follow_redirects_1 = require("follow-redirects");
const tar_fs_1 = __importDefault(require("tar-fs"));
const gunzip_maybe_1 = __importDefault(require("gunzip-maybe"));
const child_process_1 = require("child_process");
const os_1 = __importDefault(require("os"));
const simple_git_1 = __importDefault(require("simple-git"));
const shell = os_1.default.platform() === 'win32' ? 'powershell.exe' : 'bash';
const normalizeOptions = (input) => {
    let result = {
        disableAutoReturn: false,
        disableAutoReplace: false,
    };
    result = Object.assign(result, input);
    return result;
};
const createCommand = (cmd, cmdBash, opts) => {
    opts = normalizeOptions(opts);
    const hasBashSpecificCommand = cmdBash !== undefined || cmdBash !== null;
    if (hasBashSpecificCommand === true) {
        const shellName = shell;
        if (shellName === 'bash') {
            // @ts-ignore
            cmd = cmdBash;
        }
    }
    else {
        if (opts.disableAutoReplace === false) {
            // @ts-ignore
            cmd = cmdBash === null || cmdBash === void 0 ? void 0 : cmdBash.replace(';', ' && ');
        }
    }
    if (opts.disableAutoReturn === false) {
        if (cmd.endsWith('\n') === false) {
            cmd = cmd + '\n';
        }
    }
    return cmd;
};
exports.createCommand = createCommand;
function runCommand(commandStr, opts) {
    return new Promise((resolve, reject) => {
        const bash = (0, child_process_1.spawn)(shell, {
            cwd: opts.cwd,
        });
        bash.stdout.on('data', function (data) {
            console.log(String(data));
        });
        bash.stderr.on('data', function (data) {
            console.log(String(data));
        });
        bash.on('exit', function (code) {
            resolve(true);
        });
        bash.stdin.write((0, exports.createCommand)(commandStr, commandStr));
    });
}
exports.default = runCommand;
function init(cwd) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!cwd) {
            cwd = process.cwd();
        }
        const tarFilePath = path_1.default.join(cwd, 'archive.tar.gz');
        console.log('Cloning files...');
        yield new Promise((resolve, reject) => {
            const file = fs_extra_1.default.createWriteStream(tarFilePath);
            const request = follow_redirects_1.https.get({
                hostname: 'api.github.com',
                path: '/repos/skyslit/magicjs.dev-base/tarball',
                headers: {
                    'user-agent': 'Mozilla/5.0'
                }
            }, function (response) {
                response.pipe(file);
                // after download completed close filestream
                file.on("finish", () => {
                    file.close((err) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve();
                        }
                    });
                    console.log("Download Completed");
                });
            }).on('error', function (err) {
                console.error(err);
                // Handle errors
                fs_extra_1.default.unlink(tarFilePath); // Delete the file async. (But we don't check the result)
                reject(err);
            });
        });
        console.log('Extracting files...');
        yield new Promise((resolve, reject) => {
            fs_extra_1.default.createReadStream(tarFilePath)
                .pipe((0, gunzip_maybe_1.default)())
                .pipe(tar_fs_1.default.extract(path_1.default.dirname(tarFilePath), {}))
                .on('error', reject)
                .on('finish', () => {
                resolve();
            });
        });
        console.log('Installing files...');
        let extractPath = fs_extra_1.default
            .readdirSync(cwd)
            .find((d) => d.indexOf('magicjs.dev-base') > -1);
        if (extractPath) {
            extractPath = path_1.default.join(cwd, extractPath);
            fs_extra_1.default.copySync(extractPath, cwd);
            fs_extra_1.default.emptyDirSync(extractPath);
            fs_extra_1.default.rmdirSync(extractPath);
            fs_extra_1.default.rmSync(tarFilePath);
            console.log('Installing dependencies...');
            yield runCommand('npm install; exit', {
                cwd
            });
        }
        console.log('Setting up git...');
        const git = (0, simple_git_1.default)(cwd);
        yield git.init({ '--initial-branch': 'main' })
            .then(() => git.addConfig('user.email', 'bot@skyslit.dev', false, 'local'))
            .then(() => git.addConfig('user.name', 'developer', false, 'local'))
            .then(() => git.add('./*'))
            .then(() => git.commit('chore: initial commit'));
        console.log('Done ✅');
    });
}
exports.init = init;
