"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildApp = void 0;
const dev_server_1 = require("@magicjs.dev/devtools/build/dev-server");
const chalk_1 = __importDefault(require("chalk"));
function buildApp(watch = false, runtimeUrl) {
    const mode = watch === true ? 'development' : 'production';
    if (mode === 'development') {
        console.clear();
        console.log(chalk_1.default.blue(`Compiling for '${mode}' environment`));
        const cwd = process.cwd();
        (0, dev_server_1.runBuild)({
            cwd,
            runtimeUrl
        });
    }
    else {
        console.log('Building...');
        const cwd = process.cwd();
        (0, dev_server_1.runBuild)({
            cwd,
            runtimeUrl,
            env: 'production'
        });
    }
}
exports.buildApp = buildApp;
