"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addFeature = void 0;
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
const follow_redirects_1 = require("follow-redirects");
const gunzip_maybe_1 = __importDefault(require("gunzip-maybe"));
const tar_fs_1 = __importDefault(require("tar-fs"));
function addFeature(featureName, packageId, _cwd) {
    return __awaiter(this, void 0, void 0, function* () {
        const cwd = _cwd || process.cwd();
        const TEMP_FOLDER = path_1.default.join(cwd, '.temp');
        const TARGET_TAR_FILE_PATH = path_1.default.join(TEMP_FOLDER, 'archive.tar.gz');
        const FEATURE_SOURCE_DIR = path_1.default.join(cwd, 'src', 'features', featureName);
        if (fs_extra_1.default.existsSync(FEATURE_SOURCE_DIR)) {
            throw new Error(`feature '${featureName}' already exist, choose new name`);
        }
        if (fs_extra_1.default.existsSync(TEMP_FOLDER)) {
            fs_extra_1.default.emptyDirSync(TEMP_FOLDER);
        }
        else {
            fs_extra_1.default.mkdirSync(TEMP_FOLDER, { recursive: true });
        }
        yield new Promise((resolve, reject) => {
            const file = fs_extra_1.default.createWriteStream(TARGET_TAR_FILE_PATH);
            const request = follow_redirects_1.https.get({
                hostname: 'app.mern.ai',
                path: `/___service/compass/downloadTemplate?packageId=${encodeURIComponent(packageId)}`,
                headers: {
                    'user-agent': 'Mozilla/5.0'
                }
            }, function (response) {
                response.pipe(file);
                // after download completed close filestream
                file.on("finish", () => {
                    file.close((err) => {
                        if (err) {
                            reject(err);
                        }
                        else {
                            resolve();
                        }
                    });
                    console.log("Download Completed");
                });
            }).on('error', function (err) {
                console.error(err);
                // Handle errors
                fs_extra_1.default.unlink(TARGET_TAR_FILE_PATH); // Delete the file async. (But we don't check the result)
                reject(err);
            });
        });
        fs_extra_1.default.mkdirSync(FEATURE_SOURCE_DIR, { recursive: true });
        console.log('Extracting files...');
        yield new Promise((resolve, reject) => {
            fs_extra_1.default.createReadStream(TARGET_TAR_FILE_PATH)
                .pipe((0, gunzip_maybe_1.default)())
                .pipe(tar_fs_1.default.extract(FEATURE_SOURCE_DIR, {}))
                .on('error', reject)
                .on('finish', () => {
                resolve();
            });
        });
        fs_extra_1.default.emptyDirSync(TEMP_FOLDER);
        fs_extra_1.default.rmdirSync(TEMP_FOLDER);
        console.log('Package added');
    });
}
exports.addFeature = addFeature;
