"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generator = void 0;
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const services_1 = require("./services");
const _1 = require(".");
const path_1 = __importDefault(require("path"));
const USER_ROLE_MAPPING_COLLECTION_NAME = 'user_role_mapping';
function hash(payload, salt = 10) {
    const s = bcryptjs_1.default.genSaltSync();
    return bcryptjs_1.default.hashSync(payload, s);
}
function verifyHash(payload, hash) {
    return bcryptjs_1.default.compareSync(payload, hash);
}
function assignRoleToUser(userId, role) {
    return __awaiter(this, void 0, void 0, function* () {
        const collection = (0, _1.data)(USER_ROLE_MAPPING_COLLECTION_NAME);
        yield collection.updateOne({
            userId,
            role
        }, {
            $set: {}
        }, { upsert: true });
        return true;
    });
}
function unassignRoleFromUser(userId, role) {
    return __awaiter(this, void 0, void 0, function* () {
        const collection = (0, _1.data)(USER_ROLE_MAPPING_COLLECTION_NAME);
        yield collection.deleteOne({
            userId,
            role
        });
        return true;
    });
}
function findAllRolesByUser(userId) {
    return __awaiter(this, void 0, void 0, function* () {
        const collection = (0, _1.data)(USER_ROLE_MAPPING_COLLECTION_NAME);
        const matchingRoles = yield collection.find({
            userId
        }).toArray();
        return matchingRoles;
    });
}
function isUserInAnyRoles(userId, roles) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!Array.isArray(roles)) {
            roles = [roles];
        }
        const collection = (0, _1.data)(USER_ROLE_MAPPING_COLLECTION_NAME);
        const matchingRoles = yield collection.find({
            userId,
            role: {
                $in: roles
            }
        }).toArray();
        return matchingRoles.length > 0;
    });
}
/* -------------------------------------------------------------------------- */
/*                           File Upload / Download                           */
/* -------------------------------------------------------------------------- */
function saveFileToUserUploads(dir, name, file) {
    const userUploadServices = (0, services_1.getService)('user-upload-services');
    return userUploadServices.saveFileToUserUploads(dir, name, file);
}
function readFileFromUserUploads(dir, name) {
    const userUploadServices = (0, services_1.getService)('user-upload-services');
    return userUploadServices.readFileFromUserUploads(dir, name);
}
function removeFileFromUserUploads(dir, name) {
    const userUploadServices = (0, services_1.getService)('user-upload-services');
    return userUploadServices.removeFileFromUserUploads(dir, name);
}
/* -------------------------------------------------------------------------- */
/*                                Communication                               */
/* -------------------------------------------------------------------------- */
function initiateEmailVerification(emailToVerify, otp) {
    const emailVerificationService = (0, services_1.getService)('email-verify-services');
    const isVerifyEmailInitiated = emailVerificationService.initiateVerification(emailToVerify, otp);
    return isVerifyEmailInitiated;
}
function* infinite() {
    let index = 0;
    let timestamp = (new Date()).valueOf();
    const g = () => `${timestamp}_${index}`;
    while (true) {
        index++;
        yield g();
    }
    return g();
}
exports.generator = infinite();
function generateUniqueId() {
    return exports.generator.next().value;
}
function generateUniqueFilename(fileName) {
    const p = path_1.default.parse(fileName);
    return `${generateUniqueId()}${p.ext}`;
}
exports.default = {
    hash,
    verifyHash,
    saveFileToUserUploads,
    readFileFromUserUploads,
    removeFileFromUserUploads,
    initiateEmailVerification,
    assignRoleToUser,
    unassignRoleFromUser,
    isUserInAnyRoles,
    findAllRolesByUser,
    generateUniqueId,
    generateUniqueFilename
};
