/// <reference types="node" />
import { Readable } from 'stream';
export type RoleMapping = {
    userId: string;
    role: string;
};
declare function hash(payload: string, salt?: number): string;
declare function verifyHash(payload: string, hash: string): boolean;
declare function assignRoleToUser(userId: string, role: string): Promise<boolean>;
declare function unassignRoleFromUser(userId: string, role: string): Promise<boolean>;
declare function findAllRolesByUser(userId: string): Promise<RoleMapping[]>;
declare function isUserInAnyRoles(userId: string, roles: string | Array<string>): Promise<boolean>;
declare function saveFileToUserUploads(dir: string, name: string, file: Readable): void;
declare function readFileFromUserUploads(dir: string, name: string): Promise<{
    ___resMode: string;
    reader: Readable;
}>;
declare function removeFileFromUserUploads(dir: string, name: string): Promise<boolean>;
declare function initiateEmailVerification(emailToVerify: string, otp: number): Promise<Boolean>;
export declare const generator: Generator<string, string, unknown>;
declare function generateUniqueId(): string;
declare function generateUniqueFilename(fileName: string): string;
declare const _default: {
    hash: typeof hash;
    verifyHash: typeof verifyHash;
    saveFileToUserUploads: typeof saveFileToUserUploads;
    readFileFromUserUploads: typeof readFileFromUserUploads;
    removeFileFromUserUploads: typeof removeFileFromUserUploads;
    initiateEmailVerification: typeof initiateEmailVerification;
    assignRoleToUser: typeof assignRoleToUser;
    unassignRoleFromUser: typeof unassignRoleFromUser;
    isUserInAnyRoles: typeof isUserInAnyRoles;
    findAllRolesByUser: typeof findAllRolesByUser;
    generateUniqueId: typeof generateUniqueId;
    generateUniqueFilename: typeof generateUniqueFilename;
};
export default _default;
