"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUploaderUtils = void 0;
const busboy_1 = __importDefault(require("busboy"));
class UploadHandler {
    constructor(_handlers) {
        this._handlers = _handlers;
    }
    onFile(h) {
        this._handlers['_read']();
        this._handlers['onfile'] = (name, file, info) => h(info, file, name);
    }
}
function createUploaderUtils(req, res) {
    return (config) => {
        let hasInitialised = false;
        const bb = (0, busboy_1.default)(Object.assign(Object.assign({}, config || {}), { headers: req.headers }));
        const handlers = {
            '_read': () => {
                if (hasInitialised === true) {
                    return;
                }
                hasInitialised = true;
                bb.on('file', (name, file, info) => {
                    if (handlers['onfile']) {
                        handlers['onfile'](name, file, info);
                    }
                });
                bb.on('field', (name, val, info) => {
                    console.log(`Field [${name}]: value: %j`, val);
                });
                bb.on('close', () => {
                    res.json({ ack: true });
                });
                req.pipe(bb);
            }
        };
        const handler = new UploadHandler(handlers);
        return handler;
    };
}
exports.createUploaderUtils = createUploaderUtils;
