"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserUploadServices = void 0;
const core_1 = require("./core");
const path_1 = __importDefault(require("path"));
class UserUploadServices extends core_1.MERNAI_Core {
    saveFileToUserUploads(dir, name, file) {
        var _a;
        if (this.userUploadServiceEnabled === false) {
            console.warn('User upload service need non dev env id to be enabled');
        }
        (_a = this.client) === null || _a === void 0 ? void 0 : _a.request({
            method: 'post',
            url: `/blob/api/v2/buckets/${process.env['WS_ENVIRONMENT_ID']}?path=${path_1.default.posix.join(dir, name)}`,
            data: file,
            headers: {
                'Content-Type': 'application/octet-stream'
            }
        }).then((res) => {
            console.log('File uploaded');
        }).catch((err) => {
            console.error(err);
        });
    }
    removeFileFromUserUploads(dir, name) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            if (this.userUploadServiceEnabled === false) {
                console.warn('User upload service need non dev env id to be enabled');
            }
            yield ((_a = this.client) === null || _a === void 0 ? void 0 : _a.request({
                method: 'delete',
                url: `/blob/api/v2/buckets/${process.env['WS_ENVIRONMENT_ID']}?path=${path_1.default.posix.join(dir, name)}`,
                responseType: 'stream'
            }));
            return true;
        });
    }
    readFileFromUserUploads(dir, name) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            if (this.userUploadServiceEnabled === false) {
                console.warn('User upload service need non dev env id to be enabled');
            }
            const response = yield ((_a = this.client) === null || _a === void 0 ? void 0 : _a.request({
                method: 'get',
                url: `/blob/api/v2/buckets/${process.env['WS_ENVIRONMENT_ID']}?path=${path_1.default.posix.join(dir, name)}`,
                responseType: 'stream'
            }));
            return { ___resMode: 'managed', reader: response === null || response === void 0 ? void 0 : response.data };
        });
    }
}
exports.UserUploadServices = UserUploadServices;
