/// <reference types="node" />
/// <reference types="node" />
import http from 'http';
import express, { Request, Response } from 'express';
import { MongoClient, Collection } from 'mongodb';
import { RoleMapping } from './utils';
import { Server } from 'socket.io';
import { UploaderUtils } from './uploader-utils';
export declare const utils: {
    hash: (payload: string, salt?: number) => string;
    verifyHash: (payload: string, hash: string) => boolean;
    saveFileToUserUploads: (dir: string, name: string, file: import("stream").Readable) => void;
    readFileFromUserUploads: (dir: string, name: string) => Promise<{
        ___resMode: string;
        reader: import("stream").Readable;
    }>;
    removeFileFromUserUploads: (dir: string, name: string) => Promise<boolean>;
    initiateEmailVerification: (emailToVerify: string, otp: number) => Promise<Boolean>;
    assignRoleToUser: (userId: string, role: string) => Promise<boolean>;
    unassignRoleFromUser: (userId: string, role: string) => Promise<boolean>;
    isUserInAnyRoles: (userId: string, roles: string | string[]) => Promise<boolean>;
    findAllRolesByUser: (userId: string) => Promise<RoleMapping[]>;
    generateUniqueId: () => string; /** Login */
    /** Delete password */
    generateUniqueFilename: (fileName: string) => string;
};
declare global {
    namespace Express {
        interface Request {
            requestContext: RequestContext;
        }
    }
}
export declare class ServerInstance {
    static instance: ServerInstance;
    static getInstance(): ServerInstance;
    database?: MongoClient;
    httpServer: http.Server;
    io: Server;
    app: express.Express;
    port: number;
    functions: any;
    auth: {
        jwtSecret: string;
        jwtSignOpts: {
            expiresIn: string;
        };
        createCookieOptions: () => {
            expires: Date;
        };
    };
    setPort(p: number): void;
    constructor();
}
export declare function createServer(handler?: (instance: ServerInstance) => void | Promise<void>, instance?: ServerInstance): Promise<ServerInstance>;
export declare function registerBackendComponent(_moduleId: string, module: any): void;
export declare function createRoute(method: 'get' | 'post' | 'put' | 'delete', path: string, ...handlers: express.Handler[]): {
    type: string;
    payload: {
        handlers: express.Handler[];
        method: "post" | "get" | "put" | "delete";
        path: string;
    };
};
type RequestContext = {
    setCurrentUser: (user: any) => void;
    currentUser: any;
    isAuthenticated: boolean;
    roles: RoleMapping[];
    isCurrentUserInAnyRoles: (roles: string | string[]) => Promise<boolean>;
    token: string;
    advanced: {
        req: Request;
        res: Response;
    };
    coreHandler: (handler: (req: Request, res: Response) => any) => any;
    uploader: UploaderUtils;
};
export declare function createRequestContext(c: RequestContext): RequestContext;
type BackendFunction = (...args: any) => Promise<any>;
export declare function createBackendFunction(fn: BackendFunction): BackendFunction;
export declare const useFunctionContext: (t: any) => RequestContext;
export declare function invokeBackendFunction(requestContext: Partial<RequestContext>, functionPath: string, ...args: any): Promise<any>;
export declare function data(collectionName: string, dbName?: string): Collection;
export declare function io(): Server;
export declare function loadConfig(config: any): {
    getValue(propertyName: string, defaultVal?: any): any;
};
export {};
