"use strict";var e,o,n=require("@csstools/css-tokenizer"),a=require("@csstools/color-helpers"),t=require("@csstools/css-parser-algorithms"),r=require("@csstools/css-calc");function colorData_to_XYZ_D50(e){switch(e.colorNotation){case exports.ColorNotation.HEX:case exports.ColorNotation.RGB:case exports.ColorNotation.sRGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.sRGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Linear_sRGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.lin_sRGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Display_P3:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.P3_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Rec2020:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.rec_2020_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.A98_RGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.a98_RGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.ProPhoto_RGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.ProPhoto_RGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.HSL:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.HSL_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.HWB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.HWB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Lab:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.Lab_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.OKLab:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.OKLab_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.LCH:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.LCH_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.OKLCH:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.OKLCH_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.XYZ_D50:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.XYZ_D50_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.XYZ_D65:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:a.xyz.XYZ_D65_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};default:throw new Error("Unsupported color notation")}}exports.ColorNotation=void 0,(e=exports.ColorNotation||(exports.ColorNotation={})).A98_RGB="a98-rgb",e.Display_P3="display-p3",e.HEX="hex",e.HSL="hsl",e.HWB="hwb",e.LCH="lch",e.Lab="lab",e.Linear_sRGB="srgb-linear",e.OKLCH="oklch",e.OKLab="oklab",e.ProPhoto_RGB="prophoto-rgb",e.RGB="rgb",e.sRGB="srgb",e.Rec2020="rec2020",e.XYZ_D50="xyz-d50",e.XYZ_D65="xyz-d65",exports.SyntaxFlag=void 0,(o=exports.SyntaxFlag||(exports.SyntaxFlag={})).ColorKeyword="color-keyword",o.HasAlpha="has-alpha",o.HasDimensionValues="has-dimension-values",o.HasNoneKeywords="has-none-keywords",o.HasNumberValues="has-number-values",o.HasPercentageAlpha="has-percentage-alpha",o.HasPercentageValues="has-percentage-values",o.HasVariableAlpha="has-variable-alpha",o.Hex="hex",o.LegacyHSL="legacy-hsl",o.LegacyRGB="legacy-rgb",o.NamedColor="named-color",o.RelativeColorSyntax="relative-color-syntax",o.ColorMix="color-mix";const s=new Set([exports.ColorNotation.A98_RGB,exports.ColorNotation.Display_P3,exports.ColorNotation.HEX,exports.ColorNotation.Linear_sRGB,exports.ColorNotation.ProPhoto_RGB,exports.ColorNotation.RGB,exports.ColorNotation.sRGB,exports.ColorNotation.Rec2020,exports.ColorNotation.XYZ_D50,exports.ColorNotation.XYZ_D65]);function colorDataTo(e,o){const n={...e};if(e.colorNotation!==o){const e=colorData_to_XYZ_D50(n);switch(o){case exports.ColorNotation.HEX:case exports.ColorNotation.RGB:n.colorNotation=exports.ColorNotation.RGB,n.channels=a.xyz.XYZ_D50_to_sRGB(e.channels);break;case exports.ColorNotation.sRGB:n.colorNotation=exports.ColorNotation.sRGB,n.channels=a.xyz.XYZ_D50_to_sRGB(e.channels);break;case exports.ColorNotation.Linear_sRGB:n.colorNotation=exports.ColorNotation.Linear_sRGB,n.channels=a.xyz.XYZ_D50_to_lin_sRGB(e.channels);break;case exports.ColorNotation.Display_P3:n.colorNotation=exports.ColorNotation.Display_P3,n.channels=a.xyz.XYZ_D50_to_P3(e.channels);break;case exports.ColorNotation.Rec2020:n.colorNotation=exports.ColorNotation.Rec2020,n.channels=a.xyz.XYZ_D50_to_rec_2020(e.channels);break;case exports.ColorNotation.ProPhoto_RGB:n.colorNotation=exports.ColorNotation.ProPhoto_RGB,n.channels=a.xyz.XYZ_D50_to_ProPhoto(e.channels);break;case exports.ColorNotation.A98_RGB:n.colorNotation=exports.ColorNotation.A98_RGB,n.channels=a.xyz.XYZ_D50_to_a98_RGB(e.channels);break;case exports.ColorNotation.HSL:n.colorNotation=exports.ColorNotation.HSL,n.channels=a.xyz.XYZ_D50_to_HSL(e.channels);break;case exports.ColorNotation.HWB:n.colorNotation=exports.ColorNotation.HWB,n.channels=a.xyz.XYZ_D50_to_HWB(e.channels);break;case exports.ColorNotation.Lab:n.colorNotation=exports.ColorNotation.Lab,n.channels=a.xyz.XYZ_D50_to_Lab(e.channels);break;case exports.ColorNotation.LCH:n.colorNotation=exports.ColorNotation.LCH,n.channels=a.xyz.XYZ_D50_to_LCH(e.channels);break;case exports.ColorNotation.OKLCH:n.colorNotation=exports.ColorNotation.OKLCH,n.channels=a.xyz.XYZ_D50_to_OKLCH(e.channels);break;case exports.ColorNotation.OKLab:n.colorNotation=exports.ColorNotation.OKLab,n.channels=a.xyz.XYZ_D50_to_OKLab(e.channels);break;case exports.ColorNotation.XYZ_D50:n.colorNotation=exports.ColorNotation.XYZ_D50,n.channels=a.xyz.XYZ_D50_to_XYZ_D50(e.channels);break;case exports.ColorNotation.XYZ_D65:n.colorNotation=exports.ColorNotation.XYZ_D65,n.channels=a.xyz.XYZ_D50_to_XYZ_D65(e.channels);break;default:throw new Error("Unsupported color notation")}}else n.channels=e.channels.map((e=>Number.isNaN(e)?0:e));if(o===e.colorNotation)n.channels=carryForwardMissingComponents(e.channels,[0,1,2],n.channels,[0,1,2]);else if(s.has(o)&&s.has(e.colorNotation))n.channels=carryForwardMissingComponents(e.channels,[0,1,2],n.channels,[0,1,2]);else switch(o){case exports.ColorNotation.HSL:switch(e.colorNotation){case exports.ColorNotation.HWB:n.channels=carryForwardMissingComponents(e.channels,[0],n.channels,[0]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:n.channels=carryForwardMissingComponents(e.channels,[2],n.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:n.channels=carryForwardMissingComponents(e.channels,[0,1,2],n.channels,[2,1,0])}break;case exports.ColorNotation.HWB:switch(e.colorNotation){case exports.ColorNotation.HSL:n.channels=carryForwardMissingComponents(e.channels,[0],n.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:n.channels=carryForwardMissingComponents(e.channels,[0],n.channels,[2])}break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:switch(e.colorNotation){case exports.ColorNotation.HSL:n.channels=carryForwardMissingComponents(e.channels,[0],n.channels,[2]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:n.channels=carryForwardMissingComponents(e.channels,[0,1,2],n.channels,[0,1,2]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:n.channels=carryForwardMissingComponents(e.channels,[0],n.channels,[0])}break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:switch(e.colorNotation){case exports.ColorNotation.HSL:n.channels=carryForwardMissingComponents(e.channels,[0,1,2],n.channels,[2,1,0]);break;case exports.ColorNotation.HWB:n.channels=carryForwardMissingComponents(e.channels,[0],n.channels,[2]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:n.channels=carryForwardMissingComponents(e.channels,[0],n.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:n.channels=carryForwardMissingComponents(e.channels,[0,1,2],n.channels,[0,1,2])}}return n.channels=convertPowerlessComponentsToMissingComponents(n.channels,o),n}function convertPowerlessComponentsToMissingComponents(e,o){const n=[...e];switch(o){case exports.ColorNotation.HSL:reducePrecision(n[1],4)<=0&&(n[0]=NaN);break;case exports.ColorNotation.HWB:Math.max(0,reducePrecision(n[1],4))+Math.max(0,reducePrecision(n[2],4))>=100&&(n[0]=NaN);break;case exports.ColorNotation.LCH:reducePrecision(n[1],4)<=0&&(n[2]=NaN);break;case exports.ColorNotation.OKLCH:reducePrecision(n[1],6)<=0&&(n[2]=NaN)}return n}function convertPowerlessComponentsToZeroValuesForDisplay(e,o){const n=[...e];switch(o){case exports.ColorNotation.HSL:(reducePrecision(n[2])<=0||reducePrecision(n[2])>=100)&&(n[0]=NaN,n[1]=NaN),reducePrecision(n[1])<=0&&(n[0]=NaN);break;case exports.ColorNotation.HWB:Math.max(0,reducePrecision(n[1]))+Math.max(0,reducePrecision(n[2]))>=100&&(n[0]=NaN);break;case exports.ColorNotation.Lab:(reducePrecision(n[0])<=0||reducePrecision(n[0])>=100)&&(n[1]=NaN,n[2]=NaN);break;case exports.ColorNotation.LCH:reducePrecision(n[1])<=0&&(n[2]=NaN),(reducePrecision(n[0])<=0||reducePrecision(n[0])>=100)&&(n[1]=NaN,n[2]=NaN);break;case exports.ColorNotation.OKLab:(reducePrecision(n[0])<=0||reducePrecision(n[0])>=1)&&(n[1]=NaN,n[2]=NaN);break;case exports.ColorNotation.OKLCH:reducePrecision(n[1])<=0&&(n[2]=NaN),(reducePrecision(n[0])<=0||reducePrecision(n[0])>=1)&&(n[1]=NaN,n[2]=NaN)}return n}function carryForwardMissingComponents(e,o,n,a){const t=[...n];for(const n of o)Number.isNaN(e[o[n]])&&(t[a[n]]=NaN);return t}function normalizeRelativeColorDataChannels(e){const o=new Map;switch(e.colorNotation){case exports.ColorNotation.RGB:case exports.ColorNotation.HEX:o.set("r",dummyNumberToken(255*e.channels[0])),o.set("g",dummyNumberToken(255*e.channels[1])),o.set("b",dummyNumberToken(255*e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.HSL:o.set("h",dummyNumberToken(e.channels[0])),o.set("s",dummyNumberToken(e.channels[1])),o.set("l",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.HWB:o.set("h",dummyNumberToken(e.channels[0])),o.set("w",dummyNumberToken(e.channels[1])),o.set("b",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:o.set("l",dummyNumberToken(e.channels[0])),o.set("a",dummyNumberToken(e.channels[1])),o.set("b",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:o.set("l",dummyNumberToken(e.channels[0])),o.set("c",dummyNumberToken(e.channels[1])),o.set("h",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.sRGB:case exports.ColorNotation.A98_RGB:case exports.ColorNotation.Display_P3:case exports.ColorNotation.Rec2020:case exports.ColorNotation.Linear_sRGB:case exports.ColorNotation.ProPhoto_RGB:o.set("r",dummyNumberToken(e.channels[0])),o.set("g",dummyNumberToken(e.channels[1])),o.set("b",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.XYZ_D50:case exports.ColorNotation.XYZ_D65:o.set("x",dummyNumberToken(e.channels[0])),o.set("y",dummyNumberToken(e.channels[1])),o.set("z",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha))}return o}function noneToZeroInRelativeColorDataChannels(e){const o=new Map(e);for(const[n,a]of e)Number.isNaN(a[4].value)&&o.set(n,dummyNumberToken(0));return o}function dummyNumberToken(e){return[n.TokenType.Number,e.toString(),-1,-1,{value:e,type:n.NumberType.Number}]}function reducePrecision(e,o=7){if(Number.isNaN(e))return 0;const n=Math.pow(10,o);return Math.round(e*n)/n}function normalize(e,o,n,a){return Math.min(Math.max(e/o,n),a)}const l=/[A-Z]/g;function toLowerCaseAZ(e){return e.replace(l,(e=>String.fromCharCode(e.charCodeAt(0)+32)))}function normalize_Color_ChannelValues(e,o,a){if(e[0]===n.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return a.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[n.TokenType.Number,"none",e[2],e[3],{value:NaN,type:n.NumberType.Number}];if(e[0]===n.TokenType.Percentage){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,100,-1/0,1/0);return 3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,-1/0,1/0);return 3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}const i=new Set(["srgb","srgb-linear","display-p3","a98-rgb","prophoto-rgb","rec2020","xyz","xyz-d50","xyz-d65"]);function color$1(e,o){const a=[],s=[],l=[],u=[];let c,p,N=!1,m=!1;const h={colorNotation:exports.ColorNotation.sRGB,channels:[0,0,0],alpha:1,syntaxFlags:new Set([])};let y=a;for(let x=0;x<e.value.length;x++){let T=e.value[x];if(t.isWhitespaceNode(T)||t.isCommentNode(T))for(;t.isWhitespaceNode(e.value[x+1])||t.isCommentNode(e.value[x+1]);)x++;else if(y===a&&a.length&&(y=s),y===s&&s.length&&(y=l),t.isTokenNode(T)&&T.value[0]===n.TokenType.Delim&&"/"===T.value[4].value){if(y===u)return!1;y=u}else{if(t.isFunctionNode(T)){if(y===u&&"var"===toLowerCaseAZ(T.getName())){h.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),y.push(T);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(T.getName())))return!1;const[[e]]=r.calcFromComponentValues([[T]],{toCanonicalUnits:!0,precision:100,globals:p});if(!e||!t.isTokenNode(e)||(e.value[0]===n.TokenType.Percentage||e.value[0]===n.TokenType.Number||e.value[0]===n.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;T=e}if(y===a&&0===a.length&&t.isTokenNode(T)&&T.value[0]===n.TokenType.Ident&&i.has(toLowerCaseAZ(T.value[4].value))){if(N)return!1;N=toLowerCaseAZ(T.value[4].value),h.colorNotation=colorSpaceNameToColorNotation(N),m&&(m.colorNotation!==h.colorNotation&&(m=colorDataTo(m,h.colorNotation)),c=normalizeRelativeColorDataChannels(m),p=noneToZeroInRelativeColorDataChannels(c))}else if(y===a&&0===a.length&&t.isTokenNode(T)&&T.value[0]===n.TokenType.Ident&&"from"===toLowerCaseAZ(T.value[4].value)){if(m)return!1;if(N)return!1;for(;t.isWhitespaceNode(e.value[x+1])||t.isCommentNode(e.value[x+1]);)x++;if(x++,T=e.value[x],m=o(T),!1===m)return!1;h.syntaxFlags.add(exports.SyntaxFlag.RelativeColorSyntax)}else{if(!t.isTokenNode(T))return!1;if(T.value[0]===n.TokenType.Ident&&c&&c.has(toLowerCaseAZ(T.value[4].value))){y.push(new t.TokenNode(c.get(toLowerCaseAZ(T.value[4].value))));continue}y.push(T)}}}if(!N)return!1;if(1!==y.length)return!1;if(1!==a.length||1!==s.length||1!==l.length)return!1;if(!t.isTokenNode(a[0])||!t.isTokenNode(s[0])||!t.isTokenNode(l[0]))return!1;if(c&&!c.has("alpha"))return!1;const x=normalize_Color_ChannelValues(a[0].value,0,h);if(!x||x[0]!==n.TokenType.Number)return!1;const T=normalize_Color_ChannelValues(s[0].value,1,h);if(!T||T[0]!==n.TokenType.Number)return!1;const b=normalize_Color_ChannelValues(l[0].value,2,h);if(!b||b[0]!==n.TokenType.Number)return!1;const C=[x,T,b];if(1===u.length)if(h.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(u[0])){const e=normalize_Color_ChannelValues(u[0].value,3,h);if(!e||e[0]!==n.TokenType.Number)return!1;C.push(e)}else h.alpha=u[0];else if(c&&c.has("alpha")){const e=normalize_Color_ChannelValues(c.get("alpha"),3,h);if(!e||e[0]!==n.TokenType.Number)return!1;C.push(e)}return h.channels=[C[0][4].value,C[1][4].value,C[2][4].value],4===C.length&&(h.alpha=C[3][4].value),h}function colorSpaceNameToColorNotation(e){switch(e){case"srgb":return exports.ColorNotation.sRGB;case"srgb-linear":return exports.ColorNotation.Linear_sRGB;case"display-p3":return exports.ColorNotation.Display_P3;case"a98-rgb":return exports.ColorNotation.A98_RGB;case"prophoto-rgb":return exports.ColorNotation.ProPhoto_RGB;case"rec2020":return exports.ColorNotation.Rec2020;case"xyz":case"xyz-d65":return exports.ColorNotation.XYZ_D65;case"xyz-d50":return exports.ColorNotation.XYZ_D50;default:throw new Error("Unknown color space name: "+e)}}const u=new Set(["srgb","srgb-linear","lab","oklab","xyz","xyz-d50","xyz-d65"]),c=new Set(["hsl","hwb","lch","oklch"]),p=new Set(["shorter","longer","increasing","decreasing"]);function colorMix(e,o){let a=null,r=null,s=null,l=!1;for(let i=0;i<e.value.length;i++){const N=e.value[i];if(!t.isWhitespaceNode(N)&&!t.isCommentNode(N)){if(t.isTokenNode(N)&&N.value[0]===n.TokenType.Ident){if(!a&&"in"===toLowerCaseAZ(N.value[4].value)){a=N;continue}if(a&&!r){r=toLowerCaseAZ(N.value[4].value);continue}if(a&&r&&!s&&c.has(r)){s=toLowerCaseAZ(N.value[4].value);continue}if(a&&r&&s&&!l&&"hue"===toLowerCaseAZ(N.value[4].value)){l=!0;continue}return!1}return!(!t.isTokenNode(N)||N.value[0]!==n.TokenType.Comma)&&(!!r&&(s||l?!!(r&&s&&l&&c.has(r)&&p.has(s))&&colorMixPolar(r,s,colorMixComponents(e.value.slice(i+1),o)):u.has(r)?colorMixRectangular(r,colorMixComponents(e.value.slice(i+1),o)):!!c.has(r)&&colorMixPolar(r,"shorter",colorMixComponents(e.value.slice(i+1),o))))}}return!1}function colorMixComponents(e,o){const a=[];let s=1,l=!1,i=!1;for(let s=0;s<e.length;s++){let u=e[s];if(!t.isWhitespaceNode(u)&&!t.isCommentNode(u)){if(!t.isTokenNode(u)||u.value[0]!==n.TokenType.Comma){if(!l){const e=o(u);if(e){l=e;continue}}if(!i){if(t.isFunctionNode(u)&&r.mathFunctionNames.has(toLowerCaseAZ(u.getName()))&&([[u]]=r.calcFromComponentValues([[u]],{toCanonicalUnits:!0,precision:100}),!u||!t.isTokenNode(u)||(u.value[0]===n.TokenType.Percentage||u.value[0]===n.TokenType.Number||u.value[0]===n.TokenType.Dimension)&&Number.isNaN(u.value[4].value)))return!1;if(t.isTokenNode(u)&&u.value[0]===n.TokenType.Percentage&&u.value[4].value>=0){i=u.value[4].value;continue}}return!1}if(!l)return!1;a.push({color:l,percentage:i}),l=!1,i=!1}}if(l&&a.push({color:l,percentage:i}),2!==a.length)return!1;let u=a[0].percentage,c=a[1].percentage;return(!1===u||!(u<0||u>100))&&((!1===c||!(c<0||c>100))&&(!1===u&&!1===c?(u=50,c=50):!1!==u&&!1===c?c=100-u:!1===u&&!1!==c&&(u=100-c),(0!==u||0!==c)&&(!1!==u&&!1!==c&&(u+c>100&&(u=u/(u+c)*100,c=c/(u+c)*100),u+c<100&&(s=(u+c)/100,u=u/(u+c)*100,c=c/(u+c)*100),{a:{color:a[0].color,percentage:u},b:{color:a[1].color,percentage:c},alphaMultiplier:s}))))}function colorMixRectangular(e,o){if(!o)return!1;const n=o.a.color,a=o.b.color,t=o.a.percentage/100;let r=n.channels,s=a.channels,l=exports.ColorNotation.RGB,i=n.alpha;if("number"!=typeof i)return!1;let u=a.alpha;if("number"!=typeof u)return!1;switch(i=Number.isNaN(i)?u:i,u=Number.isNaN(u)?i:u,e){case"srgb":l=exports.ColorNotation.RGB;break;case"srgb-linear":l=exports.ColorNotation.Linear_sRGB;break;case"lab":l=exports.ColorNotation.Lab;break;case"oklab":l=exports.ColorNotation.OKLab;break;case"xyz-d50":l=exports.ColorNotation.XYZ_D50;break;case"xyz":case"xyz-d65":l=exports.ColorNotation.XYZ_D65}r=colorDataTo(n,l).channels,s=colorDataTo(a,l).channels,r[0]=fillInMissingComponent(r[0],s[0]),s[0]=fillInMissingComponent(s[0],r[0]),r[1]=fillInMissingComponent(r[1],s[1]),s[1]=fillInMissingComponent(s[1],r[1]),r[2]=fillInMissingComponent(r[2],s[2]),s[2]=fillInMissingComponent(s[2],r[2]),r[0]=premultiply(r[0],i),r[1]=premultiply(r[1],i),r[2]=premultiply(r[2],i),s[0]=premultiply(s[0],u),s[1]=premultiply(s[1],u),s[2]=premultiply(s[2],u);const c=interpolate(i,u,t);return{colorNotation:l,channels:[un_premultiply(interpolate(r[0],s[0],t),c),un_premultiply(interpolate(r[1],s[1],t),c),un_premultiply(interpolate(r[2],s[2],t),c)],alpha:c*o.alphaMultiplier,syntaxFlags:new Set([exports.SyntaxFlag.ColorMix])}}function colorMixPolar(e,o,n){if(!n)return!1;const a=n.a.color,t=n.b.color,r=n.a.percentage/100;let s=a.channels,l=t.channels,i=0,u=0,c=0,p=0,N=0,m=0,h=exports.ColorNotation.RGB,y=a.alpha;if("number"!=typeof y)return!1;let x=t.alpha;if("number"!=typeof x)return!1;switch(y=Number.isNaN(y)?x:y,x=Number.isNaN(x)?y:x,e){case"hsl":h=exports.ColorNotation.HSL;break;case"hwb":h=exports.ColorNotation.HWB;break;case"lch":h=exports.ColorNotation.LCH;break;case"oklch":h=exports.ColorNotation.OKLCH}switch(s=colorDataTo(a,h).channels,l=colorDataTo(t,h).channels,e){case"hsl":case"hwb":i=s[0],u=l[0],c=s[1],p=l[1],N=s[2],m=l[2];break;case"lch":case"oklch":c=s[0],p=l[0],N=s[1],m=l[1],i=s[2],u=l[2]}i=fillInMissingComponent(i,u),Number.isNaN(i)&&(i=0),u=fillInMissingComponent(u,i),Number.isNaN(u)&&(u=0),c=fillInMissingComponent(c,p),p=fillInMissingComponent(p,c),N=fillInMissingComponent(N,m),m=fillInMissingComponent(m,N);const T=u-i;switch(o){case"shorter":T>180?i+=360:T<-180&&(u+=360);break;case"longer":-180<T&&T<180&&(T>0?i+=360:u+=360);break;case"increasing":T<0&&(u+=360);break;case"decreasing":T>0&&(i+=360);break;default:throw new Error("Unknown hue interpolation method")}c=premultiply(c,y),N=premultiply(N,y),p=premultiply(p,x),m=premultiply(m,x);let b=[0,0,0];const C=interpolate(y,x,r);switch(e){case"hsl":case"hwb":b=[interpolate(i,u,r),un_premultiply(interpolate(c,p,r),C),un_premultiply(interpolate(N,m,r),C)];break;case"lch":case"oklch":b=[un_premultiply(interpolate(c,p,r),C),un_premultiply(interpolate(N,m,r),C),interpolate(i,u,r)]}return{colorNotation:h,channels:b,alpha:C*n.alphaMultiplier,syntaxFlags:new Set([exports.SyntaxFlag.ColorMix])}}function fillInMissingComponent(e,o){return Number.isNaN(e)?o:e}function interpolate(e,o,n){return e*n+o*(1-n)}function premultiply(e,o){return Number.isNaN(o)?e:Number.isNaN(e)?NaN:e*o}function un_premultiply(e,o){return 0===o||Number.isNaN(o)?e:Number.isNaN(e)?NaN:e/o}function hex(e){const o=toLowerCaseAZ(e[4].value);if(o.match(/[^a-f0-9]/))return!1;const n={colorNotation:exports.ColorNotation.HEX,channels:[0,0,0],alpha:1,syntaxFlags:new Set([exports.SyntaxFlag.Hex])},a=o.length;if(3===a){const e=o[0],a=o[1],t=o[2];return n.channels=[parseInt(e+e,16)/255,parseInt(a+a,16)/255,parseInt(t+t,16)/255],n}if(6===a){const e=o[0]+o[1],a=o[2]+o[3],t=o[4]+o[5];return n.channels=[parseInt(e,16)/255,parseInt(a,16)/255,parseInt(t,16)/255],n}if(4===a){const e=o[0],a=o[1],t=o[2],r=o[3];return n.channels=[parseInt(e+e,16)/255,parseInt(a+a,16)/255,parseInt(t+t,16)/255],n.alpha=parseInt(r+r,16)/255,n.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),n}if(8===a){const e=o[0]+o[1],a=o[2]+o[3],t=o[4]+o[5],r=o[6]+o[7];return n.channels=[parseInt(e,16)/255,parseInt(a,16)/255,parseInt(t,16)/255],n.alpha=parseInt(r,16)/255,n.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),n}return!1}function normalizeHue(e){if(e[0]===n.TokenType.Number)return e[4].value=e[4].value%360,e[1]=e[4].value.toString(),e;if(e[0]===n.TokenType.Dimension){let o=e[4].value;switch(toLowerCaseAZ(e[4].unit)){case"deg":break;case"rad":o=180*e[4].value/Math.PI;break;case"grad":o=.9*e[4].value;break;case"turn":o=360*e[4].value;break;default:return!1}return o%=360,[n.TokenType.Number,o.toString(),e[2],e[3],{value:o,type:n.NumberType.Number}]}return!1}function normalize_legacy_HSL_ChannelValues(e,o,a){if(0===o){const o=normalizeHue(e);return!1!==o&&(e[0]===n.TokenType.Dimension&&a.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===n.TokenType.Percentage){3===o?a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,1,0,100);return 3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){if(3!==o)return!1;let a=normalize(e[4].value,1,0,100);return 3===o&&(a=normalize(e[4].value,1,0,1)),[n.TokenType.Number,a.toString(),e[2],e[3],{value:a,type:n.NumberType.Number}]}return!1}function normalize_modern_HSL_ChannelValues(e,o,a){if(e[0]===n.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return a.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[n.TokenType.Number,"none",e[2],e[3],{value:NaN,type:n.NumberType.Number}];if(0===o){const o=normalizeHue(e);return!1!==o&&(e[0]===n.TokenType.Dimension&&a.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===n.TokenType.Percentage){3===o?a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=e[4].value;return 3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=e[4].value;return 3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}function threeChannelLegacySyntax(e,o,a,s){const l=[],i=[],u=[],c=[],p={colorNotation:a,channels:[0,0,0],alpha:1,syntaxFlags:new Set(s)};let N=l;for(let o=0;o<e.value.length;o++){let a=e.value[o];if(!t.isWhitespaceNode(a)&&!t.isCommentNode(a)){if(t.isTokenNode(a)&&a.value[0]===n.TokenType.Comma){if(N===l){N=i;continue}if(N===i){N=u;continue}if(N===u){N=c;continue}if(N===c)return!1}if(t.isFunctionNode(a)){if(N===c&&"var"===toLowerCaseAZ(a.getName())){p.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),N.push(a);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(a.getName())))return!1;const[[e]]=r.calcFromComponentValues([[a]],{toCanonicalUnits:!0,precision:100});if(!e||!t.isTokenNode(e)||(e.value[0]===n.TokenType.Percentage||e.value[0]===n.TokenType.Number||e.value[0]===n.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;a=e}if(!t.isTokenNode(a))return!1;N.push(a)}}if(1!==N.length)return!1;if(1!==l.length||1!==i.length||1!==u.length)return!1;if(!t.isTokenNode(l[0])||!t.isTokenNode(i[0])||!t.isTokenNode(u[0]))return!1;const m=o(l[0].value,0,p);if(!m||m[0]!==n.TokenType.Number)return!1;const h=o(i[0].value,1,p);if(!h||h[0]!==n.TokenType.Number)return!1;const y=o(u[0].value,2,p);if(!y||y[0]!==n.TokenType.Number)return!1;const x=[m,h,y];if(1===c.length)if(p.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(c[0])){const e=o(c[0].value,3,p);if(!e||e[0]!==n.TokenType.Number)return!1;x.push(e)}else p.alpha=c[0];return p.channels=[x[0][4].value,x[1][4].value,x[2][4].value],4===x.length&&(p.alpha=x[3][4].value),p}function threeChannelSpaceSeparated(e,o,a,s,l){const i=toLowerCaseAZ(e.getName()),u=[],c=[],p=[],N=[];let m,h,y=!1;const x={colorNotation:a,channels:[0,0,0],alpha:1,syntaxFlags:new Set(s)};let T=u;for(let o=0;o<e.value.length;o++){let s=e.value[o];if(t.isWhitespaceNode(s)||t.isCommentNode(s))for(;t.isWhitespaceNode(e.value[o+1])||t.isCommentNode(e.value[o+1]);)o++;else if(T===u&&u.length&&(T=c),T===c&&c.length&&(T=p),t.isTokenNode(s)&&s.value[0]===n.TokenType.Delim&&"/"===s.value[4].value){if(T===N)return!1;T=N}else{if(t.isFunctionNode(s)){if(T===N&&"var"===toLowerCaseAZ(s.getName())){x.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),T.push(s);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(s.getName())))return!1;const[[e]]=r.calcFromComponentValues([[s]],{toCanonicalUnits:!0,precision:100,globals:h});if(!e||!t.isTokenNode(e)||(e.value[0]===n.TokenType.Percentage||e.value[0]===n.TokenType.Number||e.value[0]===n.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;s=e}if(T===u&&0===u.length&&t.isTokenNode(s)&&s.value[0]===n.TokenType.Ident&&"from"===toLowerCaseAZ(s.value[4].value)&&"hsla"!==i&&"rgba"!==i){if(y)return!1;for(;t.isWhitespaceNode(e.value[o+1])||t.isCommentNode(e.value[o+1]);)o++;if(o++,s=e.value[o],y=l(s),!1===y)return!1;x.syntaxFlags.add(exports.SyntaxFlag.RelativeColorSyntax),y.colorNotation!==a&&(y=colorDataTo(y,a)),m=normalizeRelativeColorDataChannels(y),h=noneToZeroInRelativeColorDataChannels(m)}else{if(!t.isTokenNode(s))return!1;if(s.value[0]===n.TokenType.Ident&&m&&m.has(toLowerCaseAZ(s.value[4].value))){T.push(new t.TokenNode(m.get(toLowerCaseAZ(s.value[4].value))));continue}T.push(s)}}}if(1!==T.length)return!1;if(1!==u.length||1!==c.length||1!==p.length)return!1;if(!t.isTokenNode(u[0])||!t.isTokenNode(c[0])||!t.isTokenNode(p[0]))return!1;if(m&&!m.has("alpha"))return!1;const b=o(u[0].value,0,x);if(!b||b[0]!==n.TokenType.Number)return!1;const C=o(c[0].value,1,x);if(!C||C[0]!==n.TokenType.Number)return!1;const d=o(p[0].value,2,x);if(!d||d[0]!==n.TokenType.Number)return!1;const g=[b,C,d];if(1===N.length)if(x.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(N[0])){const e=o(N[0].value,3,x);if(!e||e[0]!==n.TokenType.Number)return!1;g.push(e)}else x.alpha=N[0];else if(m&&m.has("alpha")){const e=o(m.get("alpha"),3,x);if(!e||e[0]!==n.TokenType.Number)return!1;g.push(e)}return x.channels=[g[0][4].value,g[1][4].value,g[2][4].value],4===g.length&&(x.alpha=g[3][4].value),x}function hsl(e,o){if(e.value.some((e=>t.isTokenNode(e)&&e.value[0]===n.TokenType.Comma))){const o=hslCommaSeparated(e);if(!1!==o)return o}{const n=hslSpaceSeparated(e,o);if(!1!==n)return n}return!1}function hslCommaSeparated(e){return threeChannelLegacySyntax(e,normalize_legacy_HSL_ChannelValues,exports.ColorNotation.HSL,[exports.SyntaxFlag.LegacyHSL])}function hslSpaceSeparated(e,o){return threeChannelSpaceSeparated(e,normalize_modern_HSL_ChannelValues,exports.ColorNotation.HSL,[],o)}function normalize_HWB_ChannelValues(e,o,a){if(e[0]===n.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return a.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[n.TokenType.Number,"none",e[2],e[3],{value:NaN,type:n.NumberType.Number}];if(0===o){const o=normalizeHue(e);return!1!==o&&(e[0]===n.TokenType.Dimension&&a.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===n.TokenType.Percentage){3===o?a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=e[4].value;return 3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=e[4].value;return 3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}function normalize_Lab_ChannelValues(e,o,a){if(e[0]===n.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return a.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[n.TokenType.Number,"none",e[2],e[3],{value:NaN,type:n.NumberType.Number}];if(e[0]===n.TokenType.Percentage){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,1,0,100);return 1===o||2===o?t=normalize(e[4].value,.8,-1/0,1/0):3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,0,100);return 1===o||2===o?t=normalize(e[4].value,1,-1/0,1/0):3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}function lab(e,o){return threeChannelSpaceSeparated(e,normalize_Lab_ChannelValues,exports.ColorNotation.Lab,[],o)}function normalize_LCH_ChannelValues(e,o,a){if(e[0]===n.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return a.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[n.TokenType.Number,"none",e[2],e[3],{value:NaN,type:n.NumberType.Number}];if(2===o){const o=normalizeHue(e);return!1!==o&&(e[0]===n.TokenType.Dimension&&a.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===n.TokenType.Percentage){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,1,0,100);return 1===o?t=normalize(e[4].value,100/150,0,1/0):3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,0,100);return 1===o?t=normalize(e[4].value,1,0,1/0):3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}function lch(e,o){return threeChannelSpaceSeparated(e,normalize_LCH_ChannelValues,exports.ColorNotation.LCH,[],o)}const N=new Map;for(const[e,o]of Object.entries(a.namedColors))N.set(e,o);function namedColor(e){const o=N.get(toLowerCaseAZ(e));return!!o&&{colorNotation:exports.ColorNotation.RGB,channels:[o[0]/255,o[1]/255,o[2]/255],alpha:1,syntaxFlags:new Set([exports.SyntaxFlag.ColorKeyword,exports.SyntaxFlag.NamedColor])}}function normalize_OKLab_ChannelValues(e,o,a){if(e[0]===n.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return a.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[n.TokenType.Number,"none",e[2],e[3],{value:NaN,type:n.NumberType.Number}];if(e[0]===n.TokenType.Percentage){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,100,0,1);return 1===o||2===o?t=normalize(e[4].value,250,-1/0,1/0):3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,0,1);return 1===o||2===o?t=normalize(e[4].value,1,-1/0,1/0):3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}function oklab(e,o){return threeChannelSpaceSeparated(e,normalize_OKLab_ChannelValues,exports.ColorNotation.OKLab,[],o)}function normalize_OKLCH_ChannelValues(e,o,a){if(e[0]===n.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return a.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[n.TokenType.Number,"none",e[2],e[3],{value:NaN,type:n.NumberType.Number}];if(2===o){const o=normalizeHue(e);return!1!==o&&(e[0]===n.TokenType.Dimension&&a.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===n.TokenType.Percentage){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,100,0,1);return 1===o?t=normalize(e[4].value,250,0,1/0):3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,0,1);return 1===o?t=normalize(e[4].value,1,0,1/0):3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}function oklch(e,o){return threeChannelSpaceSeparated(e,normalize_OKLCH_ChannelValues,exports.ColorNotation.OKLCH,[],o)}function normalize_legacy_sRGB_ChannelValues(e,o,a){if(e[0]===n.TokenType.Percentage){3===o?a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);const t=normalize(e[4].value,100,0,1);return[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,255,0,1);return 3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}function normalize_modern_sRGB_ChannelValues(e,o,a){if(e[0]===n.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return a.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[n.TokenType.Number,"none",e[2],e[3],{value:NaN,type:n.NumberType.Number}];if(e[0]===n.TokenType.Percentage){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,100,-1/0,1/0);return 3===o&&(t=normalize(e[4].value,100,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}if(e[0]===n.TokenType.Number){3!==o&&a.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,255,-1/0,1/0);return 3===o&&(t=normalize(e[4].value,1,0,1)),[n.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:n.NumberType.Number}]}return!1}function rgb(e,o){if(e.value.some((e=>t.isTokenNode(e)&&e.value[0]===n.TokenType.Comma))){const o=rgbCommaSeparated(e);if(!1!==o)return(!o.syntaxFlags.has(exports.SyntaxFlag.HasNumberValues)||!o.syntaxFlags.has(exports.SyntaxFlag.HasPercentageValues))&&o}else{const n=rgbSpaceSeparated(e,o);if(!1!==n)return n}return!1}function rgbCommaSeparated(e){return threeChannelLegacySyntax(e,normalize_legacy_sRGB_ChannelValues,exports.ColorNotation.RGB,[exports.SyntaxFlag.LegacyRGB])}function rgbSpaceSeparated(e,o){return threeChannelSpaceSeparated(e,normalize_modern_sRGB_ChannelValues,exports.ColorNotation.RGB,[],o)}function toPrecision(e,o=7){e=+e,o=+o;const n=(Math.floor(e)+"").length;if(o>n)return+e.toFixed(o-n);{const a=10**(n-o);return Math.round(e/a)*a}}function XYZ_D50_to_P3_Gamut(e){const o=a.xyz.XYZ_D50_to_P3(e);if(a.utils.inGamut(o))return a.utils.clip(o);let n=e.slice();return n=a.conversions.D50_to_D65(n),n=a.conversions.XYZ_to_OKLab(n),n=a.conversions.OKLab_to_OKLCH(n),n[0]<1e-6&&(n=[0,0,0]),n[0]>.999999&&(n=[1,0,0]),a.calculations.mapGamut(n,(e=>(e=a.conversions.OKLCH_to_OKLab(e),e=a.conversions.OKLab_to_XYZ(e),e=a.conversions.XYZ_to_lin_P3(e),a.conversions.gam_P3(e))),(e=>(e=a.conversions.lin_P3(e),e=a.conversions.lin_P3_to_XYZ(e),e=a.conversions.XYZ_to_OKLab(e),a.conversions.OKLab_to_OKLCH(e))))}function serializeWithAlpha(e,o,a,r){const s=[n.TokenType.CloseParen,")",-1,-1,void 0];if("number"==typeof e.alpha){const l=Math.min(1,Math.max(0,toPrecision(Number.isNaN(e.alpha)?0:e.alpha)));return 1===toPrecision(l,4)?new t.FunctionNode(o,s,r):new t.FunctionNode(o,s,[...r,new t.WhitespaceNode([a]),new t.TokenNode([n.TokenType.Delim,"/",-1,-1,{value:"/"}]),new t.WhitespaceNode([a]),new t.TokenNode([n.TokenType.Number,toPrecision(l,4).toString(),-1,-1,{value:e.alpha,type:n.NumberType.Integer}])])}return new t.FunctionNode(o,s,[...r,new t.WhitespaceNode([a]),new t.TokenNode([n.TokenType.Delim,"/",-1,-1,{value:"/"}]),new t.WhitespaceNode([a]),e.alpha])}function XYZ_D50_to_sRGB_Gamut(e){const o=a.xyz.XYZ_D50_to_sRGB(e);if(a.utils.inGamut(o))return a.utils.clip(o);let n=e.slice();return n=a.conversions.D50_to_D65(n),n=a.conversions.XYZ_to_OKLab(n),n=a.conversions.OKLab_to_OKLCH(n),n[0]<1e-6&&(n=[0,0,0]),n[0]>.999999&&(n=[1,0,0]),a.calculations.mapGamut(n,(e=>(e=a.conversions.OKLCH_to_OKLab(e),e=a.conversions.OKLab_to_XYZ(e),e=a.conversions.XYZ_to_lin_sRGB(e),a.conversions.gam_sRGB(e))),(e=>(e=a.conversions.lin_sRGB(e),e=a.conversions.lin_sRGB_to_XYZ(e),e=a.conversions.XYZ_to_OKLab(e),a.conversions.OKLab_to_OKLCH(e))))}exports.color=function color(e){if(t.isFunctionNode(e)){switch(toLowerCaseAZ(e.getName())){case"rgb":case"rgba":return rgb(e,color);case"hsl":case"hsla":return hsl(e,color);case"hwb":return o=color,threeChannelSpaceSeparated(e,normalize_HWB_ChannelValues,exports.ColorNotation.HWB,[],o);case"lab":return lab(e,color);case"lch":return lch(e,color);case"oklab":return oklab(e,color);case"oklch":return oklch(e,color);case"color":return color$1(e,color);case"color-mix":return colorMix(e,color)}}var o;if(t.isTokenNode(e)){if(e.value[0]===n.TokenType.Hash)return hex(e.value);if(e.value[0]===n.TokenType.Ident){const o=namedColor(e.value[4].value);return!1!==o?o:"transparent"===toLowerCaseAZ(e.value[4].value)&&{colorNotation:exports.ColorNotation.RGB,channels:[0,0,0],alpha:0,syntaxFlags:new Set([exports.SyntaxFlag.ColorKeyword])}}}return!1},exports.colorDataFitsDisplayP3_Gamut=function colorDataFitsDisplayP3_Gamut(e){const o={...e,channels:[...e.channels]};return o.channels=convertPowerlessComponentsToZeroValuesForDisplay(o.channels,o.colorNotation),!colorDataTo(o,exports.ColorNotation.Display_P3).channels.find((e=>e<-1e-5||e>1.00001))},exports.colorDataFitsRGB_Gamut=function colorDataFitsRGB_Gamut(e){const o={...e,channels:[...e.channels]};return o.channels=convertPowerlessComponentsToZeroValuesForDisplay(o.channels,o.colorNotation),!colorDataTo(o,exports.ColorNotation.RGB).channels.find((e=>e<-1e-5||e>1.00001))},exports.colorDataTo=colorDataTo,exports.serializeOKLCH=function serializeOKLCH(e){e.channels=convertPowerlessComponentsToZeroValuesForDisplay(e.channels,e.colorNotation);let o=e.channels.map((e=>Number.isNaN(e)?0:e));e.colorNotation!==exports.ColorNotation.OKLCH&&(o=a.xyz.XYZ_D50_to_OKLCH(colorData_to_XYZ_D50(e).channels));const r=toPrecision(o[0],6),s=toPrecision(o[1],6),l=toPrecision(o[2],6),i=[n.TokenType.Function,"oklch(",-1,-1,{value:"oklch"}],u=[n.TokenType.Whitespace," ",-1,-1,void 0];return serializeWithAlpha(e,i,u,[new t.TokenNode([n.TokenType.Number,r.toString(),-1,-1,{value:o[0],type:n.NumberType.Number}]),new t.WhitespaceNode([u]),new t.TokenNode([n.TokenType.Number,s.toString(),-1,-1,{value:o[1],type:n.NumberType.Number}]),new t.WhitespaceNode([u]),new t.TokenNode([n.TokenType.Number,l.toString(),-1,-1,{value:o[2],type:n.NumberType.Number}])])},exports.serializeP3=function serializeP3(e,o=!0){e.channels=convertPowerlessComponentsToZeroValuesForDisplay(e.channels,e.colorNotation);let r=e.channels.map((e=>Number.isNaN(e)?0:e));e.colorNotation!==exports.ColorNotation.Display_P3&&(r=o?XYZ_D50_to_P3_Gamut(colorData_to_XYZ_D50(e).channels):a.xyz.XYZ_D50_to_P3(colorData_to_XYZ_D50(e).channels));const s=toPrecision(r[0],6),l=toPrecision(r[1],6),i=toPrecision(r[2],6),u=[n.TokenType.Function,"color(",-1,-1,{value:"color"}],c=[n.TokenType.Whitespace," ",-1,-1,void 0];return serializeWithAlpha(e,u,c,[new t.TokenNode([n.TokenType.Ident,"display-p3",-1,-1,{value:"display-p3"}]),new t.WhitespaceNode([c]),new t.TokenNode([n.TokenType.Number,s.toString(),-1,-1,{value:r[0],type:n.NumberType.Number}]),new t.WhitespaceNode([c]),new t.TokenNode([n.TokenType.Number,l.toString(),-1,-1,{value:r[1],type:n.NumberType.Number}]),new t.WhitespaceNode([c]),new t.TokenNode([n.TokenType.Number,i.toString(),-1,-1,{value:r[2],type:n.NumberType.Number}])])},exports.serializeRGB=function serializeRGB(e,o=!0){e.channels=convertPowerlessComponentsToZeroValuesForDisplay(e.channels,e.colorNotation);let r=e.channels.map((e=>Number.isNaN(e)?0:e));r=o?XYZ_D50_to_sRGB_Gamut(colorData_to_XYZ_D50(e).channels):a.xyz.XYZ_D50_to_sRGB(colorData_to_XYZ_D50(e).channels);const s=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[0])))),l=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[1])))),i=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[2])))),u=[n.TokenType.CloseParen,")",-1,-1,void 0],c=[n.TokenType.Whitespace," ",-1,-1,void 0],p=[n.TokenType.Comma,",",-1,-1,void 0],N=[new t.TokenNode([n.TokenType.Number,s.toString(),-1,-1,{value:r[0],type:n.NumberType.Integer}]),new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([n.TokenType.Number,l.toString(),-1,-1,{value:r[1],type:n.NumberType.Integer}]),new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([n.TokenType.Number,i.toString(),-1,-1,{value:r[2],type:n.NumberType.Integer}])];if("number"==typeof e.alpha){const o=Math.min(1,Math.max(0,toPrecision(Number.isNaN(e.alpha)?0:e.alpha)));return 1===toPrecision(o,4)?new t.FunctionNode([n.TokenType.Function,"rgb(",-1,-1,{value:"rgb"}],u,N):new t.FunctionNode([n.TokenType.Function,"rgba(",-1,-1,{value:"rgba"}],u,[...N,new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([n.TokenType.Number,toPrecision(o,4).toString(),-1,-1,{value:e.alpha,type:n.NumberType.Number}])])}return new t.FunctionNode([n.TokenType.Function,"rgba(",-1,-1,{value:"rgba"}],u,[...N,new t.TokenNode(p),new t.WhitespaceNode([c]),e.alpha])};
